/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.io.IOException;
import java.time.Clock;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.graphdb.Resource;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.async.AsyncBlockAccessor;
import org.neo4j.io.async.AsyncCompletionHandler;
import org.neo4j.io.async.AsyncFailureHandler;
import org.neo4j.io.async.AsyncIOProvider;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.AsyncCheckpointCompletionHandler;
import org.neo4j.io.pagecache.impl.muninn.AsyncCheckpointFailureHandler;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.DatabaseTracers;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointThreshold;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.LatestCheckpointInfo;
import org.neo4j.kernel.impl.transaction.log.checkpoint.StoreCopyCheckPointMutex;
import org.neo4j.kernel.impl.transaction.log.checkpoint.TriggerInfo;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.pruning.LogPruning;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.impl.transaction.tracing.LogCheckPointEvent;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.ClosedBatchMetadata;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.OpenTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.time.Stopwatch;
import org.neo4j.util.VisibleForTesting;

public class CheckPointerImpl
extends LifecycleAdapter
implements CheckPointer {
    private static final String CHECKPOINT_TAG = "checkpoint";
    private static final long NO_APPEND_INDEX = -1L;
    private static final String IO_DETAILS_TEMPLATE = "Checkpoint flushed %d pages (%d%% of total available pages), in %d IOs. Checkpoint performed with IO limit: %s, paused in total %d times(%d millis). Average checkpoint flush speed: %s.";
    private static final String UNLIMITED_IO_CONTROLLER_LIMIT = "unlimited";
    private final CheckpointFile checkpointFile;
    private final LogMetadataProvider metadataProvider;
    private final CheckPointThreshold threshold;
    private final ForceOperation forceOperation;
    private final LogPruning logPruning;
    private final Panic databasePanic;
    private final InternalLog log;
    private final DatabaseTracers tracers;
    private final StoreCopyCheckPointMutex mutex;
    private final CursorContextFactory cursorContextFactory;
    private final Clock clock;
    private final IOController ioController;
    private final MemoryTracker memoryTracker;
    private final Config config;
    private volatile boolean shutdown;
    private volatile LatestCheckpointInfo latestCheckPointInfo = LatestCheckpointInfo.UNKNOWN_CHECKPOINT_INFO;

    public CheckPointerImpl(LogMetadataProvider metadataProvider, CheckPointThreshold threshold, ForceOperation forceOperation, LogPruning logPruning, CheckpointFile checkpointFile, Panic databasePanic, InternalLogProvider logProvider, DatabaseTracers tracers, StoreCopyCheckPointMutex mutex, CursorContextFactory cursorContextFactory, Clock clock, IOController ioController, MemoryTracker memoryTracker, Config config) {
        this.checkpointFile = checkpointFile;
        this.metadataProvider = metadataProvider;
        this.threshold = threshold;
        this.forceOperation = forceOperation;
        this.logPruning = logPruning;
        this.databasePanic = databasePanic;
        this.log = logProvider.getLog(CheckPointerImpl.class);
        this.tracers = tracers;
        this.mutex = mutex;
        this.cursorContextFactory = cursorContextFactory;
        this.clock = clock;
        this.ioController = ioController;
        this.memoryTracker = memoryTracker;
        this.config = config;
    }

    public void start() {
        ClosedBatchMetadata lastClosedBatch = this.metadataProvider.getLastClosedBatch();
        this.threshold.initialize(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition());
    }

    @Override
    public void shutdown() {
        try (Resource ignored = this.mutex.checkPoint();){
            this.shutdown = true;
        }
    }

    @Override
    public long forceCheckPoint(TriggerInfo info) throws IOException {
        try (Resource lock = this.mutex.checkPoint();){
            long l = this.checkpointByTrigger(info);
            return l;
        }
    }

    @Override
    public long forceCheckPoint(TransactionId transactionId, long appendIndex, LogPosition position, TriggerInfo triggerInfo) throws IOException {
        try (Resource lock = this.mutex.checkPoint();){
            long l = this.checkpointByExternalParams(transactionId, appendIndex, position, position, appendIndex, triggerInfo);
            return l;
        }
    }

    @Override
    public long tryCheckPoint(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> false);
    }

    @Override
    public long tryCheckPointNoWait(TriggerInfo info) throws IOException {
        return this.tryCheckPoint(info, () -> true);
    }

    @Override
    public long tryCheckPoint(TriggerInfo info, BooleanSupplier timeout) throws IOException {
        Resource lockAttempt = this.mutex.tryCheckPoint();
        if (lockAttempt != null) {
            try (Resource resource = lockAttempt;){
                long l = this.checkpointByTrigger(info);
                return l;
            }
        }
        try (Resource lock = this.mutex.tryCheckPoint(timeout);){
            if (lock != null) {
                LatestCheckpointInfo lastInfo = this.latestCheckPointInfo;
                this.log.info(info.describe(lastInfo) + " Check pointing was already running, completed now");
                long l = lastInfo.appendIndex();
                return l;
            }
            long l = -1L;
            return l;
        }
    }

    @Override
    public long checkPointIfNeeded(TriggerInfo info) throws IOException {
        ClosedBatchMetadata lastClosedBatch = this.metadataProvider.getLastClosedBatch();
        if (this.threshold.isCheckPointingNeeded(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition(), info)) {
            try (Resource lock = this.mutex.checkPoint();){
                long l = this.checkpointByTrigger(info);
                return l;
            }
        }
        return -1L;
    }

    private long checkpointByTrigger(TriggerInfo triggerInfo) throws IOException {
        if (this.shutdown) {
            this.logShutdownMessage(triggerInfo);
            return -1L;
        }
        TransactionId highestTransactionEver = this.metadataProvider.getHighestEverClosedTransaction();
        ClosedBatchMetadata lastClosedBatch = this.metadataProvider.getLastClosedBatch();
        NotCompletedTransactionInfo oldestNotVisibleTransactionInfo = this.evaluateOldestNotVisibleTransactionInfo(lastClosedBatch);
        return this.checkpointByExternalParams(highestTransactionEver, oldestNotVisibleTransactionInfo.appendIndex(), oldestNotVisibleTransactionInfo.logPosition(), lastClosedBatch.logPosition(), lastClosedBatch.appendIndex(), triggerInfo);
    }

    private long checkpointByExternalParams(TransactionId transactionId, long oldestNotVisibleAppendIndex, LogPosition oldestNotCompletedPosition, LogPosition checkpointedLogPosition, long appendIndex, TriggerInfo triggerInfo) throws IOException {
        if (this.shutdown) {
            this.logShutdownMessage(triggerInfo);
            return -1L;
        }
        return this.doCheckpoint(transactionId, appendIndex, oldestNotVisibleAppendIndex, oldestNotCompletedPosition, checkpointedLogPosition, triggerInfo);
    }

    @VisibleForTesting
    AsyncBlockAccessor createAsyncBlockAccessor(AsyncIOProvider asyncIOProvider, MemoryTracker memoryTracker, DatabaseFlushEvent flushEvent) {
        if (((Boolean)this.config.get(GraphDatabaseInternalSettings.pagecache_async_io)).booleanValue()) {
            return asyncIOProvider.createAsyncBlockAccessor(128, (AsyncCompletionHandler)new AsyncCheckpointCompletionHandler(flushEvent), (AsyncFailureHandler)new AsyncCheckpointFailureHandler(flushEvent), memoryTracker);
        }
        return AsyncBlockAccessor.EMPTY_ASYNC_BLOCK_ACCESSOR;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private long doCheckpoint(TransactionId transactionId, long appendIndex, long oldestNotVisibleAppendIndex, LogPosition oldestNotCompletedPosition, LogPosition checkpointedLogPosition, TriggerInfo triggerInfo) throws IOException {
        DatabaseTracer databaseTracer = this.tracers.getDatabaseTracer();
        try (CursorContext cursorContext = this.cursorContextFactory.create(CHECKPOINT_TAG);){
            LogCheckPointEvent checkPointEvent = databaseTracer.beginCheckPoint();
            try {
                long highestEverClosedTransactionId = transactionId.id();
                cursorContext.getVersionContext().initWrite(highestEverClosedTransactionId);
                cursorContext.getVersionContext().initAppendIndex(transactionId.appendIndex());
                KernelVersion kernelVersion = this.metadataProvider.kernelVersion();
                LatestCheckpointInfo ongoingCheckpoint = new LatestCheckpointInfo(kernelVersion, transactionId, oldestNotVisibleAppendIndex, checkpointedLogPosition);
                String checkpointReason = triggerInfo.describe(ongoingCheckpoint);
                this.databasePanic.assertNoPanic(IOException.class);
                this.log.info(checkpointReason + " checkpoint started...");
                Stopwatch startTime = Stopwatch.start();
                try (DatabaseFlushEvent flushEvent = checkPointEvent.beginDatabaseFlush();
                     AsyncBlockAccessor asyncBlockAccessor = this.createAsyncBlockAccessor(AsyncIOProvider.getInstance(), this.memoryTracker, flushEvent);){
                    this.forceOperation.flushAndForce(flushEvent, asyncBlockAccessor, cursorContext);
                    flushEvent.ioControllerLimit(this.ioController.configuredLimit());
                }
                this.databasePanic.assertNoPanic(IOException.class);
                this.checkpointFile.getCheckpointAppender().checkPoint(checkPointEvent, transactionId, appendIndex, kernelVersion, oldestNotCompletedPosition, checkpointedLogPosition, this.clock.instant(), checkpointReason);
                this.threshold.checkPointHappened(appendIndex, checkpointedLogPosition);
                long durationMillis = startTime.elapsed(TimeUnit.MILLISECONDS);
                checkPointEvent.checkpointCompleted(durationMillis);
                this.log.info(this.createCheckpointMessageDescription(checkPointEvent, checkpointReason, durationMillis));
                this.logPruning.pruneLogs(oldestNotCompletedPosition.getLogVersion());
                this.latestCheckPointInfo = ongoingCheckpoint;
                long l = this.latestCheckPointInfo.appendIndex();
                if (checkPointEvent != null) {
                    checkPointEvent.close();
                }
                return l;
            }
            catch (Throwable throwable) {
                if (checkPointEvent != null) {
                    try {
                        checkPointEvent.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.log.error("Checkpoint failed", t);
            throw t;
        }
    }

    private String createCheckpointMessageDescription(LogCheckPointEvent checkpointEvent, String checkpointReason, long durationMillis) {
        double flushRatio = checkpointEvent.flushRatio();
        long ioLimit = checkpointEvent.getConfiguredIOLimit();
        String averageSpeedPerSecond = CheckPointerImpl.getAverageSpeed(checkpointEvent, durationMillis);
        String ioDetails = IO_DETAILS_TEMPLATE.formatted(checkpointEvent.getPagesFlushed(), (int)(flushRatio * 100.0), checkpointEvent.getIOsPerformed(), this.ioLimitDescription(ioLimit), checkpointEvent.getTimesPaused(), checkpointEvent.getMillisPaused(), averageSpeedPerSecond);
        return checkpointReason + " checkpoint completed in " + Format.duration((long)durationMillis) + ". " + ioDetails;
    }

    private static String getAverageSpeed(LogCheckPointEvent checkpointEvent, long durationMillis) {
        long totalFlushedBytes = checkpointEvent.getPagesFlushed() * 8192L;
        long seconds = Duration.ofMillis(durationMillis).toSeconds();
        long bytesPerSecond = seconds == 0L ? totalFlushedBytes : totalFlushedBytes / seconds;
        return ByteUnit.bytesToString((long)bytesPerSecond) + "/s";
    }

    private String ioLimitDescription(long ioLimit) {
        if (!this.ioController.isEnabled() || ioLimit < 0L) {
            return UNLIMITED_IO_CONTROLLER_LIMIT;
        }
        return this.ioController.isIopsBasedLimit() ? ioLimit + " IOPS" : ByteUnit.bytesToString((long)(ioLimit * 8192L)) + "/s";
    }

    private void logShutdownMessage(TriggerInfo triggerInfo) {
        this.log.warn("Checkpoint was requested on already shutdown checkpointer. Requester: " + triggerInfo.describe(LatestCheckpointInfo.UNKNOWN_CHECKPOINT_INFO));
    }

    private NotCompletedTransactionInfo evaluateOldestNotVisibleTransactionInfo(ClosedBatchMetadata lastClosedBatch) {
        OpenTransactionMetadata openTransactionMetadata = this.metadataProvider.getOldestOpenTransaction();
        if (openTransactionMetadata == null) {
            return new NotCompletedTransactionInfo(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition());
        }
        long oldestBatchAppendIndex = openTransactionMetadata.appendIndex();
        if (oldestBatchAppendIndex > lastClosedBatch.appendIndex()) {
            return new NotCompletedTransactionInfo(lastClosedBatch.appendIndex(), lastClosedBatch.logPosition());
        }
        return new NotCompletedTransactionInfo(openTransactionMetadata.appendIndex() - 1L, openTransactionMetadata.logPosition());
    }

    @Override
    public LatestCheckpointInfo latestCheckPointInfo() {
        return this.latestCheckPointInfo;
    }

    @FunctionalInterface
    public static interface ForceOperation {
        public static final ForceOperation NO_OP = (flushEvent, asyncBlockAccessor, cursorContext) -> {};

        public void flushAndForce(DatabaseFlushEvent var1, AsyncBlockAccessor var2, CursorContext var3) throws IOException;
    }

    private record NotCompletedTransactionInfo(long appendIndex, LogPosition logPosition) {
    }
}

