/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.TransactionMetadataCache;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.Monitors;
import org.neo4j.storageengine.api.CommandReaderFactory;

public class ReadOnlyTransactionStore
implements LogicalTransactionStore {
    private final LogicalTransactionStore physicalStore;

    public ReadOnlyTransactionStore(FileSystemAbstraction fs, DatabaseLayout fromDatabaseLayout, Config config, Monitors monitors, CommandReaderFactory commandReaderFactory) throws IOException {
        TransactionMetadataCache transactionMetadataCache = new TransactionMetadataCache();
        LogFiles logFiles = LogFilesBuilder.readableBuilder(fromDatabaseLayout, fs, KernelVersionProvider.THROWING_PROVIDER, LogFormatVersionProvider.THROWING_PROVIDER).withCommandReaderFactory(commandReaderFactory).withConfig(config).withInitializeProviders().build();
        this.physicalStore = new PhysicalLogicalTransactionStore(logFiles, transactionMetadataCache, commandReaderFactory, monitors, true, config, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    @Override
    public CommandBatchCursor getCommandBatches(long appendIndexToStartFrom) throws IOException {
        return this.physicalStore.getCommandBatches(appendIndexToStartFrom);
    }

    @Override
    public CommandBatchCursor getCommandBatches(LogPosition position) throws IOException {
        return this.physicalStore.getCommandBatches(position);
    }

    @Override
    public CommandBatchCursor getCommandBatchesInReverseOrder(LogPosition backToPosition) throws IOException {
        return this.physicalStore.getCommandBatchesInReverseOrder(backToPosition);
    }
}

