/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.LogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.memory.MemoryTracker;

public class ReadAheadLogChannel
extends ReadAheadChannel<LogVersionedStoreChannel>
implements ReadableLogChannel {
    private final LogVersionBridge bridge;
    private final boolean raw;

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, MemoryTracker memoryTracker) {
        this(startingChannel, LogVersionBridge.NO_MORE_CHANNELS, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker), false);
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, MemoryTracker memoryTracker) {
        this(startingChannel, bridge, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker), false);
    }

    public ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, MemoryTracker memoryTracker, boolean raw) {
        this(startingChannel, bridge, (ScopedBuffer)new NativeScopedBuffer(DEFAULT_READ_AHEAD_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker), raw);
    }

    protected ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, ScopedBuffer scopedBuffer, boolean raw) {
        this(startingChannel, LogVersionBridge.NO_MORE_CHANNELS, scopedBuffer, raw);
    }

    private ReadAheadLogChannel(LogVersionedStoreChannel startingChannel, LogVersionBridge bridge, ScopedBuffer scopedBuffer, boolean raw) {
        super((StoreChannel)startingChannel, scopedBuffer);
        this.bridge = bridge;
        this.raw = raw;
    }

    public long getLogVersion() {
        return ((LogVersionedStoreChannel)this.channel).getLogVersion();
    }

    public LogFormat getLogFormatVersion() {
        return ((LogVersionedStoreChannel)this.channel).getLogFormatVersion();
    }

    public LogPosition firstEntryPosition() {
        int headerSize = this.getLogFormatVersion().getHeaderSize();
        return new LogPosition(this.getLogVersion(), (long)headerSize);
    }

    public byte markAndGetVersion(LogPositionMarker marker) throws IOException {
        LogPositionMarker currentMarker = this.getCurrentLogPosition(marker);
        byte data = this.getVersion();
        if (!currentMarker.isMarkerInLog(((LogVersionedStoreChannel)this.channel).getLogVersion())) {
            marker.mark(((LogVersionedStoreChannel)this.channel).getLogVersion(), this.position() - 1L);
        }
        return data;
    }

    public int directRead(ByteBuffer dst) throws IOException {
        return this.read(dst);
    }

    public long alignWithStartEntry() throws IOException {
        return this.position();
    }

    public LogPositionMarker getCurrentLogPosition(LogPositionMarker positionMarker) throws IOException {
        positionMarker.mark(((LogVersionedStoreChannel)this.channel).getLogVersion(), this.position());
        return positionMarker;
    }

    public LogPosition getCurrentLogPosition() throws IOException {
        return new LogPosition(((LogVersionedStoreChannel)this.channel).getLogVersion(), this.position());
    }

    public void setLogPosition(LogPositionMarker positionMarker) throws IOException {
        if (positionMarker.getLogVersion() != ((LogVersionedStoreChannel)this.channel).getLogVersion()) {
            throw new IllegalArgumentException("Log position points log version %d but the current one is %d".formatted(positionMarker.getLogVersion(), ((LogVersionedStoreChannel)this.channel).getLogVersion()));
        }
        this.position(positionMarker.getByteOffset());
    }

    protected LogVersionedStoreChannel next(LogVersionedStoreChannel channel) throws IOException {
        return this.bridge.next(channel, this.raw);
    }

    public void resetToPosition(long byteOffset) throws IOException {
        super.zeroOutBuffers();
        this.position(byteOffset);
    }
}

