/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CompleteCommandBatch;
import org.neo4j.kernel.impl.transaction.log.LogIndexEncoding;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryWriter;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.Leases;
import org.neo4j.storageengine.api.StorageCommand;

public record CompleteBatchRepresentation(LogEntryStart startEntry, CommandBatch commandBatch, LogEntryCommit commitEntry, int previousChecksum) implements CommittedCommandBatchRepresentation
{
    public CompleteBatchRepresentation(LogEntryStart startEntry, List<StorageCommand> commands, LogEntryCommit commitEntry, int previousChecksum) {
        this(startEntry, new CompleteCommandBatch(commands, LogIndexEncoding.decodeLogIndex(startEntry.getAdditionalHeader()), startEntry.getTimeWritten(), startEntry.getLastCommittedTxWhenTransactionStarted(), commitEntry.getTimeWritten(), -1, Leases.NO_LEASES, startEntry.kernelVersion(), Subject.ANONYMOUS), commitEntry, previousChecksum);
    }

    @Override
    public int serialize(LogEntryWriter<? extends WritableChannel> writer) throws IOException {
        KernelVersion kernelVersion = this.startEntry.kernelVersion();
        writer.writeStartEntry(this.startEntry);
        writer.serialize(this.commandBatch);
        return writer.writeCommitEntry(kernelVersion, this.commitEntry.getTxId(), this.commitEntry.getTimeWritten());
    }

    @Override
    public long appendIndex() {
        return this.startEntry.kernelVersion().isAtLeast(KernelVersion.VERSION_APPEND_INDEX_INTRODUCED) ? this.startEntry.getAppendIndex() : this.commitEntry.getTxId();
    }

    @Override
    public int checksum() {
        return this.commitEntry.getChecksum();
    }

    @Override
    public long timeWritten() {
        return this.commitEntry.getTimeWritten();
    }

    @Override
    public long txId() {
        return this.commitEntry.getTxId();
    }

    @Override
    public boolean isRollback() {
        return false;
    }

    @Override
    public long previousBatchAppendIndex() {
        return 0L;
    }

    @Override
    public String toString() {
        return "CommittedTransactionRepresentation{startEntry=" + String.valueOf(this.startEntry) + ", transactionRepresentation=" + String.valueOf(this.commandBatch) + ", commitEntry=" + String.valueOf(this.commitEntry) + "}";
    }
}

