/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.core.util.NullOutputStream;
import org.neo4j.batchimport.api.AdditionalInitialIds;
import org.neo4j.batchimport.api.BatchImporter;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IndexConfig;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.ExternallyManagedPageCache;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.impl.index.schema.DefaultIndexProvidersAccess;
import org.neo4j.kernel.impl.storemigration.ExistingTargetStrategy;
import org.neo4j.kernel.impl.storemigration.FileOperation;
import org.neo4j.kernel.impl.storemigration.SchemaMigrator;
import org.neo4j.kernel.impl.storemigration.StoreMigratorFileOperation;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadataFactory;
import org.neo4j.kernel.impl.transaction.log.files.LogTailMetadataFactoryImpl;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogInitializer;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.Lifespan;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.Index44Compatibility;
import org.neo4j.storageengine.migration.AbstractStoreMigrationParticipant;

public class AcrossEngineMigrationParticipant
extends AbstractStoreMigrationParticipant {
    private final Config config;
    private final LogService logService;
    private final FileSystemAbstraction fileSystem;
    private final PageCache pageCache;
    private final PageCacheTracer pageCacheTracer;
    private final JobScheduler jobScheduler;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;
    private final StorageEngineFactory srcStorageEngine;
    private final StorageEngineFactory targetStorageEngine;
    private final boolean forceBtreeIndexesToRange;
    private final boolean keepNodeIds;
    private final long maxOffHeapMemory;
    private final PrintStream verboseProgressOutput;
    private final boolean verboseOutput;

    public AcrossEngineMigrationParticipant(FileSystemAbstraction fileSystem, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, LogService logService, JobScheduler jobScheduler, CursorContextFactory contextFactory, MemoryTracker memoryTracker, StorageEngineFactory srcStorageEngine, StorageEngineFactory targetStorageEngine, boolean forceBtreeIndexesToRange, boolean keepNodeIds, long maxOffHeapMemory, PrintStream verboseProgressOutput, boolean verboseOutput) {
        super("store files");
        this.fileSystem = fileSystem;
        this.pageCache = pageCache;
        this.config = config;
        this.logService = logService;
        this.jobScheduler = jobScheduler;
        this.pageCacheTracer = pageCacheTracer;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
        this.srcStorageEngine = srcStorageEngine;
        this.targetStorageEngine = targetStorageEngine;
        this.forceBtreeIndexesToRange = forceBtreeIndexesToRange;
        this.keepNodeIds = keepNodeIds;
        this.maxOffHeapMemory = maxOffHeapMemory;
        this.verboseProgressOutput = verboseProgressOutput;
        this.verboseOutput = verboseOutput;
    }

    public void migrate(DatabaseLayout directoryLayoutArg, DatabaseLayout migrationLayoutArg, ProgressListener progressListener, StoreVersion fromVersion, StoreVersion toVersion, IndexImporterFactory indexImporterFactory, LogTailMetadata tailMetadata) throws IOException, KernelException {
        PrintStream progressOutput;
        Monitor progressTrackingMonitor;
        Config localConfig = Config.newBuilder().fromConfig(this.config).set(GraphDatabaseSettings.db_format, (Object)toVersion.formatName()).build();
        Lifespan life = new Lifespan(new Lifecycle[0]);
        AdditionalInitialIds additionalInitialIds = AcrossEngineMigrationParticipant.getInitialIds(tailMetadata);
        DefaultIndexProvidersAccess indexProviders = (DefaultIndexProvidersAccess)life.add((Lifecycle)new DefaultIndexProvidersAccess(this.targetStorageEngine, this.fileSystem, this.config, this.jobScheduler, this.logService, this.pageCacheTracer, this.contextFactory));
        if (this.verboseOutput) {
            progressTrackingMonitor = Monitor.NO_MONITOR;
            progressOutput = this.verboseProgressOutput;
        } else {
            progressTrackingMonitor = this.progressTrackingMonitor(progressListener);
            progressOutput = new PrintStream(NullOutputStream.nullOutputStream());
        }
        BatchImporter importer = this.targetStorageEngine.batchImporter(migrationLayoutArg, this.fileSystem, false, this.pageCacheTracer, (Configuration)new Configuration.Overridden(Configuration.defaultConfiguration()){

            public IndexConfig indexConfig() {
                return IndexConfig.create().withLabelIndex().withRelationshipTypeIndex();
            }

            public ExternallyManagedPageCache providedPageCache() {
                return AcrossEngineMigrationParticipant.this.maxOffHeapMemory == -1L ? new ExternallyManagedPageCache(AcrossEngineMigrationParticipant.this.pageCache) : null;
            }

            public long maxOffHeapMemory() {
                return AcrossEngineMigrationParticipant.this.maxOffHeapMemory == -1L ? super.maxOffHeapMemory() : AcrossEngineMigrationParticipant.this.maxOffHeapMemory;
            }

            public boolean enableInstrumentation() {
                return false;
            }
        }, this.logService, progressOutput, this.verboseOutput, additionalInitialIds, (LogTailMetadataFactory)new LogTailMetadataFactoryImpl(this.fileSystem), localConfig, progressTrackingMonitor, this.jobScheduler, Collector.EMPTY, TransactionLogInitializer.getLogFilesInitializer(), indexImporterFactory, this.memoryTracker, this.contextFactory, (IndexProvidersAccess)indexProviders, 0, null);
        try (Input fromInput = this.srcStorageEngine.asBatchImporterInput(directoryLayoutArg, this.fileSystem, this.pageCache, this.pageCacheTracer, localConfig, this.memoryTracker, ReadBehaviour.INCLUSIVE_STRICT, !this.keepNodeIds, this.contextFactory, tailMetadata);
             Lifespan lifespan = life;){
            if (!this.targetStorageEngine.supportsVectorData() && fromInput.containsVectorData()) {
                throw new UnsupportedOperationException("Provided input is known to contain vector value data, which is not supported by the target storage engine.");
            }
            importer.doImport(fromInput);
        }
        SchemaMigrator.migrateSchemaRules(this.srcStorageEngine, this.targetStorageEngine, this.fileSystem, this.pageCache, this.pageCacheTracer, localConfig, directoryLayoutArg, migrationLayoutArg, fromVersion.hasCapability((Capability)Index44Compatibility.INSTANCE), this.contextFactory, tailMetadata, this.forceBtreeIndexesToRange, ReadBehaviour.INCLUSIVE_STRICT, this.memoryTracker);
    }

    private Monitor progressTrackingMonitor(final ProgressListener progressReporter) {
        return new Monitor(){
            private int lastReportedPercentage;

            public void percentageCompleted(int percentage) {
                int diff = percentage - this.lastReportedPercentage;
                if (diff > 0) {
                    progressReporter.add((long)diff);
                    this.lastReportedPercentage = percentage;
                }
            }
        };
    }

    public void moveMigratedFiles(DatabaseLayout migrationLayoutArg, DatabaseLayout directoryLayoutArg, StoreVersion versionToUpgradeFrom, StoreVersion versionToUpgradeTo, MemoryTracker memoryTracker) throws IOException {
        Path indexFolder;
        DatabaseLayout mig = this.targetStorageEngine.formatSpecificDatabaseLayout(migrationLayoutArg);
        DatabaseLayout dir = this.srcStorageEngine.formatSpecificDatabaseLayout(directoryLayoutArg);
        Path toplevelIndexFolder = indexFolder = IndexDirectoryStructure.baseSchemaIndexFolder((Path)dir.databaseDirectory());
        while (!toplevelIndexFolder.getParent().equals(dir.databaseDirectory())) {
            toplevelIndexFolder = toplevelIndexFolder.getParent();
        }
        Path profiles = dir.databaseDirectory().resolve("profiles");
        List storeFiles = new ArrayList<Path>(this.srcStorageEngine.listStorageFiles(this.fileSystem, dir));
        storeFiles.add(toplevelIndexFolder);
        storeFiles.add(profiles);
        storeFiles.add(dir.file(Path.of("neostore.labelscanstore.db", new String[0])));
        storeFiles.add(dir.file(Path.of("neostore.relationshiptypescanstore.db", new String[0])));
        StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.DELETE_INCLUDING_DIRS, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)dir, (DatabaseLayout)mig, (Path[])storeFiles.toArray(new Path[0]), (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.OVERWRITE);
        Path migIndexFolder = IndexDirectoryStructure.baseSchemaIndexFolder((Path)mig.databaseDirectory());
        storeFiles = this.targetStorageEngine.listStorageFiles(this.fileSystem, mig);
        StoreMigratorFileOperation.fileOperation((FileOperation)FileOperation.MOVE, (FileSystemAbstraction)this.fileSystem, (DatabaseLayout)mig, (DatabaseLayout)dir, (Path[])storeFiles.toArray(new Path[0]), (boolean)true, (ExistingTargetStrategy)ExistingTargetStrategy.OVERWRITE);
        this.fileSystem.moveToDirectory(migIndexFolder, indexFolder.getParent());
    }

    public void postMigration(DatabaseLayout databaseLayout, StoreVersion toVersion, long txIdBeforeMigration, long txIdAfterMigration) {
    }

    public void cleanup(DatabaseLayout migrationLayout) throws IOException {
    }

    private static AdditionalInitialIds getInitialIds(final LogTailMetadata tailMetadata) {
        return new AdditionalInitialIds(){

            public long lastCommittedTransactionId() {
                return tailMetadata.getLastCommittedTransaction().id();
            }

            public int lastCommittedTransactionChecksum() {
                return tailMetadata.getLastCommittedTransaction().checksum();
            }

            public long lastCommittedTransactionLogVersion() {
                return tailMetadata.getLastTransactionLogPosition().getLogVersion();
            }

            public long lastCommittedTransactionLogByteOffset() {
                return tailMetadata.getLastTransactionLogPosition().getByteOffset();
            }

            public long checkpointLogVersion() {
                return tailMetadata.getCheckpointLogVersion();
            }

            public long lastAppendIndex() {
                return tailMetadata.getLastCheckpointedAppendIndex();
            }

            public long lastCommittedTransactionAppendIndex() {
                return tailMetadata.getLastCommittedTransaction().appendIndex();
            }
        };
    }
}

