/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.io.IOUtils;
import org.neo4j.lang.CloseListener;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;

public class FilteringRelationshipScanCursorWrapper
implements RelationshipScanCursor {
    private final RelationshipScanCursor delegate;
    private final Predicate<RelationshipScanCursor> filter;
    private final Collection<AutoCloseable> resources;

    public FilteringRelationshipScanCursorWrapper(RelationshipScanCursor delegate, Predicate<RelationshipScanCursor> filter) {
        this(delegate, filter, Collections.emptyList());
    }

    public FilteringRelationshipScanCursorWrapper(RelationshipScanCursor delegate, Predicate<RelationshipScanCursor> filter, Collection<AutoCloseable> resources) {
        this.delegate = delegate;
        this.filter = filter;
        this.resources = resources;
    }

    public RelationshipScanCursor internalRelationshipCursor() {
        return this.delegate;
    }

    public boolean next() {
        while (this.delegate.next()) {
            if (!this.filter.test(this.delegate)) continue;
            return true;
        }
        return false;
    }

    public void close() {
        IOUtils.closeAllSilently(this.resources);
        this.delegate.close();
    }

    public void closeInternal() {
        this.delegate.closeInternal();
    }

    public boolean isClosed() {
        return this.delegate.isClosed();
    }

    public void setCloseListener(CloseListener closeListener) {
        this.delegate.setCloseListener(closeListener);
    }

    public void setToken(int token) {
        this.delegate.setToken(token);
    }

    public int getToken() {
        return this.delegate.getToken();
    }

    public void setTracer(KernelReadTracer tracer) {
        this.delegate.setTracer(tracer);
    }

    public void removeTracer() {
        this.delegate.removeTracer();
    }

    public long relationshipReference() {
        return this.delegate.relationshipReference();
    }

    public int type() {
        return this.delegate.type();
    }

    public void source(NodeCursor cursor) {
        this.delegate.source(cursor);
    }

    public void target(NodeCursor cursor) {
        this.delegate.target(cursor);
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        this.delegate.properties(cursor, selection);
    }

    public long sourceNodeReference() {
        return this.delegate.sourceNodeReference();
    }

    public long targetNodeReference() {
        return this.delegate.targetNodeReference();
    }

    public Reference propertiesReference() {
        return this.delegate.propertiesReference();
    }
}

