/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.storageengine.api.ReadTracer;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;

public class DefaultRelationshipTraversalCursor
extends DefaultRelationshipCursor<DefaultRelationshipTraversalCursor>
implements RelationshipTraversalCursor {
    private final StorageRelationshipTraversalCursor storeCursor;
    private long originNodeReference;
    private RelationshipSelection selection;
    private long neighbourNodeReference;

    protected DefaultRelationshipTraversalCursor(CursorPool<DefaultRelationshipTraversalCursor> pool, StorageRelationshipTraversalCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super((StorageRelationshipCursor)storeCursor, pool, applyAccessModeToTxState, internalCursors);
        this.storeCursor = storeCursor;
    }

    void init(long nodeReference, long reference, RelationshipSelection selection, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.originNodeReference = nodeReference;
        this.selection = selection;
        this.neighbourNodeReference = -1L;
        this.storeCursor.init(nodeReference, reference, selection);
    }

    void init(DefaultNodeCursor nodeCursor, RelationshipSelection selection, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.originNodeReference = nodeCursor.nodeReference();
        this.selection = selection;
        this.neighbourNodeReference = -1L;
        if (!nodeCursor.currentNodeIsAddedInChunk()) {
            nodeCursor.storeCursor.relationships(this.storeCursor, selection);
        } else {
            this.storeCursor.reset();
        }
    }

    void init(long addedRelationship, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        assert (addedRelationship != -1L);
        this.init(read, txStateHolder, accessModeProvider);
        this.originNodeReference = -1L;
        this.neighbourNodeReference = -1L;
        this.selection = null;
        this.storeCursor.reset();
        this.prepareChanges(PrimitiveLongCollections.single((long)addedRelationship), true);
    }

    void init(DefaultNodeCursor nodeCursor, RelationshipSelection selection, long neighbourNodeReference, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.originNodeReference = nodeCursor.nodeReference();
        this.selection = selection;
        this.neighbourNodeReference = neighbourNodeReference;
        if (!nodeCursor.currentNodeIsAddedInChunk()) {
            nodeCursor.storeCursor.relationshipsTo(this.storeCursor, selection, neighbourNodeReference);
        } else {
            this.storeCursor.reset();
        }
    }

    @Override
    protected void maybeTraceStoreHit() {
    }

    public void otherNode(NodeCursor cursor) {
        this.read.singleNode(this.otherNodeReference(), cursor);
    }

    public long otherNodeReference() {
        if (this.currentAddedInTx != -1L) {
            long originNodeReference = this.originNodeReference();
            if (this.txStateSourceNodeReference == originNodeReference) {
                return this.txStateTargetNodeReference;
            }
            if (this.txStateTargetNodeReference == originNodeReference) {
                return this.txStateSourceNodeReference;
            }
            throw new IllegalStateException(String.format("Relationship[%d] which was added in tx has an origin node [%d] which is neither source [%d] nor target [%d]", this.currentAddedInTx, originNodeReference, this.txStateSourceNodeReference, this.txStateTargetNodeReference));
        }
        return this.storeCursor.neighbourNodeReference();
    }

    public long originNodeReference() {
        return this.originNodeReference;
    }

    @Override
    protected boolean filterOutTxStateRelationship() {
        return this.neighbourNodeReference != -1L && this.otherNodeReference() != this.neighbourNodeReference;
    }

    @Override
    public void setTracer(KernelReadTracer tracer) {
        super.setTracer(tracer);
        this.storeCursor.setTracer((ReadTracer)tracer);
    }

    @Override
    public void removeTracer() {
        this.storeCursor.removeTracer();
        super.removeTracer();
    }

    @Override
    protected boolean allowedToTraverseEndNodes() {
        if (this.allowAllNodes) {
            return true;
        }
        DefaultNodeCursor nodeCursor = this.getSecurityNodeCursor();
        this.read.singleNode(this.chooseNeighbourReferenceForSecurityCheck(), (NodeCursor)nodeCursor);
        return nodeCursor.next();
    }

    private long chooseNeighbourReferenceForSecurityCheck() {
        if (this.applyAccessModeToTxState && this.currentAddedInTx != -1L && this.neighbourNodeReference != -1L) {
            return this.neighbourNodeReference;
        }
        return this.storeCursor.neighbourNodeReference();
    }

    @Override
    public void closeInternal() {
        this.selection = null;
        super.closeInternal();
    }

    @Override
    protected LongIterator collectAddedTxStateSnapshot(TxStateHolder stateHolder) {
        if (this.selection != null) {
            return this.selection.addedRelationships(stateHolder.txState().getNodeState(this.originNodeReference));
        }
        return ImmutableEmptyLongIterator.INSTANCE;
    }

    public String toString() {
        if (this.isClosed()) {
            return this.getClass().getSimpleName() + "[closed state]";
        }
        return this.getClass().getSimpleName() + "[id=" + this.storeCursor.entityReference() + ", " + String.valueOf(this.storeCursor) + "]";
    }
}

