/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.KernelReadTracer;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.AccessControlDataProvider;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.TraceablePropertyCursor;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageProperty;

public class DefaultNodeValueIndexCursor
extends DefaultEntityValueIndexCursor<DefaultNodeValueIndexCursor>
implements NodeValueIndexCursor {
    private final InternalCursorFactory internalCursors;
    private DefaultNodeCursor securityNodeCursor;
    private TraceablePropertyCursor propertyCursor;
    private int[] propertyIds;
    private AccessControlDataProvider accessControlDataProvider;

    DefaultNodeValueIndexCursor(CursorPool<DefaultNodeValueIndexCursor> pool, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool, applyAccessModeToTxState);
        this.internalCursors = internalCursors;
    }

    @Override
    protected boolean canAccessAllDescribedEntities(IndexDescriptor descriptor) {
        this.propertyIds = descriptor.schema().getPropertyIds();
        int[] labelIds = descriptor.schema().getEntityTokenIds();
        return this.accessMode.allowsTraverseAndReadAllMatchingNodeProperties(labelIds, this.propertyIds);
    }

    @Override
    void traceOnEntity(KernelReadTracer tracer, long entity) {
        tracer.onNode(entity);
    }

    @Override
    String implementationName() {
        return "NodeValueIndexCursor";
    }

    @Override
    protected final boolean canAccessEntityAndProperties(long reference) {
        this.ensureSecurityNodeCursor();
        this.read.singleNode(reference, (NodeCursor)this.securityNodeCursor);
        if (!this.securityNodeCursor.next()) {
            return false;
        }
        assert (this.accessMode == this.accessModeProvider.getAccessMode()) : "access mode changed while cursor is in use";
        return this.accessMode.allowsReadNodeProperties(() -> AccessControlDataProvider.nodeLabels(this.securityNodeCursor, this.applyAccessModeToTxState), this.propertyIds, this::getAccessControlDataProvider);
    }

    private AccessControlDataProvider getAccessControlDataProvider() {
        if (this.accessControlDataProvider == null) {
            this.accessControlDataProvider = new AccessControlDataProvider(() -> (propertyCursor, selection) -> {
                if (this.securityNodeCursor.storeCursor.entityReference() != -1L) {
                    propertyCursor.initNodeProperties(this.securityNodeCursor.storeCursor, selection);
                }
            }, this.internalCursors, this.applyAccessModeToTxState, this::txStateProperties, () -> this.read);
        }
        return this.accessControlDataProvider;
    }

    private Iterable<StorageProperty> txStateProperties() {
        if (this.txStateHolder.hasTxStateWithChanges()) {
            return this.txStateHolder.txState().getNodeState(this.securityNodeCursor.nodeReference()).addedProperties();
        }
        return Iterables.empty();
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.entityReference(), cursor);
    }

    public long nodeReference() {
        return this.entityReference();
    }

    @Override
    protected LongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)removedFromIndex).asUnmodifiable();
    }

    @Override
    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
            this.securityNodeCursor = null;
        }
        if (this.propertyCursor != null) {
            this.propertyCursor.close();
            this.propertyCursor.release();
            this.propertyCursor = null;
        }
        if (this.accessControlDataProvider != null) {
            this.accessControlDataProvider.close();
            this.accessControlDataProvider.release();
            this.accessControlDataProvider = null;
        }
    }

    @Override
    protected boolean doStoreValuePassesQueryFilter(long reference, PropertySelection propertySelection, PropertyIndexQuery[] query) {
        this.ensureSecurityNodeCursor();
        this.read.singleNode(reference, (NodeCursor)this.securityNodeCursor);
        if (this.securityNodeCursor.next()) {
            this.ensurePropertyCursor();
            this.securityNodeCursor.properties(this.propertyCursor, propertySelection);
            return CursorPredicates.propertiesMatch(this.propertyCursor, query);
        }
        return false;
    }

    private void ensureSecurityNodeCursor() {
        if (this.securityNodeCursor == null) {
            this.securityNodeCursor = this.internalCursors.allocateNodeCursor();
        }
    }

    private void ensurePropertyCursor() {
        if (this.propertyCursor == null) {
            this.propertyCursor = this.internalCursors.allocatePropertyCursor();
        }
    }
}

