/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.diffset.IntDiffSets;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.AccessControlDataProvider;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultPropertyCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipTraversalCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.TraceableCursorImpl;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.Degrees;
import org.neo4j.storageengine.api.LongReference;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.Reference;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.NodeState;
import org.neo4j.storageengine.util.EagerDegrees;
import org.neo4j.storageengine.util.SingleDegree;

public class DefaultNodeCursor
extends TraceableCursorImpl<DefaultNodeCursor>
implements NodeCursor {
    final StorageNodeCursor storeCursor;
    private final InternalCursorFactory internalCursors;
    protected Read read;
    private TxStateHolder txStateHolder;
    boolean checkHasChanges;
    boolean hasChanges;
    private LongIterator addedNodes;
    private long currentAddedInChunk = -1L;
    private long single;
    private boolean isSingle;
    private final boolean applyAccessModeToTxState;
    private AccessModeProvider accessModeProvider;
    private AccessMode accessMode;
    private AccessControlDataProvider accessControlDataProvider;
    private DefaultRelationshipTraversalCursor securityRelationshipTraversalCursor;

    protected DefaultNodeCursor(CursorPool<DefaultNodeCursor> pool, StorageNodeCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super(pool);
        this.storeCursor = storeCursor;
        this.internalCursors = internalCursors;
        this.applyAccessModeToTxState = applyAccessModeToTxState;
    }

    void scan(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider, boolean includeChangesFromThisTransaction) {
        this.storeCursor.scan();
        this.read = read;
        this.txStateHolder = includeChangesFromThisTransaction ? txStateHolder : TxStateHolder.EMPTY_TX_STATE;
        this.accessModeProvider = accessModeProvider;
        this.accessMode = accessModeProvider.getAccessMode();
        this.isSingle = false;
        this.currentAddedInChunk = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        if (this.tracer != null) {
            this.tracer.onAllNodesScan();
        }
    }

    boolean scanBatch(Read read, AllNodeScan scan, long sizeHint, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
        this.accessMode = accessModeProvider.getAccessMode();
        this.isSingle = false;
        this.currentAddedInChunk = -1L;
        this.checkHasChanges = false;
        this.hasChanges = false;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
        return this.storeCursor.scanBatch((Scan)scan, sizeHint);
    }

    void single(long reference, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.storeCursor.single(reference);
        this.read = read;
        this.txStateHolder = txStateHolder;
        this.accessModeProvider = accessModeProvider;
        this.accessMode = accessModeProvider.getAccessMode();
        this.single = reference;
        this.isSingle = true;
        this.currentAddedInChunk = -1L;
        this.checkHasChanges = true;
        this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
    }

    protected boolean currentNodeIsAddedInChunk() {
        return this.currentAddedInChunk != -1L;
    }

    public long nodeReference() {
        if (this.currentAddedInChunk != -1L) {
            return this.currentAddedInChunk;
        }
        return this.storeCursor.entityReference();
    }

    public TokenSet labels() {
        return this.labels(this.storeCursor);
    }

    public TokenSet labelsAndProperties(PropertyCursor propertyCursor, PropertySelection selection) {
        if (this.currentAddedInChunk != -1L) {
            TransactionState txState = this.txStateHolder.txState();
            this.properties(propertyCursor, selection);
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInChunk).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            IntHashSet labels = new IntHashSet(this.storeCursor.labels());
            this.properties(propertyCursor, selection);
            return Labels.from((IntSet)txState.augmentLabels((MutableIntSet)labels, txState.getNodeState(this.storeCursor.entityReference())));
        }
        return this.readLabelsAndProperties(propertyCursor, selection);
    }

    protected TokenSet readLabelsAndProperties(PropertyCursor propertyCursor, PropertySelection selection) {
        DefaultPropertyCursor defaultPropertyCursor = (DefaultPropertyCursor)propertyCursor;
        int[] labels = this.storeCursor.labelsAndProperties(defaultPropertyCursor.storeCursor, selection);
        defaultPropertyCursor.initNode(this, selection, this.read, false, this.txStateHolder, this.accessModeProvider);
        return Labels.from(labels);
    }

    public TokenSet labelsIgnoringTxStateSetRemove() {
        if (this.currentAddedInChunk != -1L) {
            TransactionState txState = this.txStateHolder.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInChunk).getAdded());
        }
        return Labels.from(this.storeCursor.labels());
    }

    public boolean hasLabel(int label) {
        if (this.tracer != null) {
            this.tracer.onHasLabel(label);
        }
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            IntDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.isAdded(label)) {
                return true;
            }
            if (this.currentNodeIsAddedInChunk() || diffSets.isRemoved(label)) {
                return false;
            }
        }
        return this.storeCursor.hasLabel(label);
    }

    public boolean hasLabel() {
        if (this.tracer != null) {
            this.tracer.onHasLabel();
        }
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            IntDiffSets diffSets = txState.nodeStateLabelDiffSets(this.nodeReference());
            if (diffSets.getAdded().notEmpty()) {
                return true;
            }
            if (this.currentNodeIsAddedInChunk()) {
                return false;
            }
            if (diffSets.getRemoved().notEmpty()) {
                return this.labels().numberOfTokens() > 0;
            }
        }
        return this.storeCursor.hasLabel();
    }

    public void relationships(RelationshipTraversalCursor cursor, RelationshipSelection selection) {
        ((DefaultRelationshipTraversalCursor)cursor).init(this, selection, this.read, this.txStateHolder, this.accessModeProvider);
    }

    public boolean supportsFastRelationshipsTo() {
        return this.currentAddedInChunk == -1L && this.storeCursor.supportsFastRelationshipsTo();
    }

    public void relationshipsTo(RelationshipTraversalCursor relationships, RelationshipSelection selection, long neighbourNodeReference) {
        ((DefaultRelationshipTraversalCursor)relationships).init(this, selection, neighbourNodeReference, this.read, this.txStateHolder, this.accessModeProvider);
    }

    public void properties(PropertyCursor cursor, PropertySelection selection) {
        ((DefaultPropertyCursor)cursor).initNode(this, selection, this.read, true, this.txStateHolder, this.accessModeProvider);
    }

    public long relationshipsReference() {
        return this.currentAddedInChunk != -1L ? -1L : this.storeCursor.relationshipsReference();
    }

    public Reference propertiesReference() {
        return this.currentAddedInChunk != -1L ? LongReference.NULL_REFERENCE : this.storeCursor.propertiesReference();
    }

    public boolean supportsFastDegreeLookup() {
        return (this.currentAddedInChunk != -1L || this.storeCursor.supportsFastDegreeLookup()) && this.allowsTraverseAll();
    }

    public int[] relationshipTypes() {
        MutableIntSet types;
        boolean hasChanges = this.hasChanges();
        NodeState nodeTxState = hasChanges ? this.txStateHolder.txState().getNodeState(this.nodeReference()) : null;
        int[] storedTypes = this.currentAddedInChunk == -1L ? this.storeCursor.relationshipTypes() : null;
        MutableIntSet mutableIntSet = types = storedTypes != null ? IntSets.mutable.of(storedTypes) : IntSets.mutable.empty();
        if (nodeTxState != null) {
            types.addAll(nodeTxState.getAddedRelationshipTypes());
        }
        return types.toArray();
    }

    public Degrees degrees(RelationshipSelection selection) {
        EagerDegrees degrees = new EagerDegrees();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees;
    }

    public int degree(RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree();
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return degrees.getTotal();
    }

    public int degreeWithMax(int maxDegree, RelationshipSelection selection) {
        SingleDegree degrees = new SingleDegree(maxDegree);
        this.fillDegrees(selection, (Degrees.Mutator)degrees);
        return Math.min(degrees.getTotal(), maxDegree);
    }

    private void fillDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        NodeState nodeTxState;
        if (!this.allowsTraverseAll()) {
            this.readRestrictedDegrees(selection, degrees);
            return;
        }
        if (this.hasChanges() && (nodeTxState = this.txStateHolder.txState().getNodeState(this.nodeReference())) != null && !nodeTxState.fillDegrees(selection, degrees)) {
            return;
        }
        if (this.currentNodeIsAddedInChunk()) {
            return;
        }
        this.storeCursor.degrees(selection, degrees);
    }

    private void readRestrictedDegrees(RelationshipSelection selection, Degrees.Mutator degrees) {
        DefaultRelationshipTraversalCursor cursor = this.getSecurityRelationshipTraversalCursor();
        this.relationships(cursor, selection);
        long thisReference = this.nodeReference();
        while (cursor.next()) {
            boolean incoming;
            long target;
            long source;
            boolean loop;
            boolean outgoing;
            int type = cursor.type();
            if (degrees.add(type, (outgoing = !(loop = (source = cursor.sourceNodeReference()) == (target = cursor.targetNodeReference())) && source == thisReference) ? 1 : 0, (incoming = !loop && !outgoing) ? 1 : 0, loop ? 1 : 0)) continue;
            return;
        }
    }

    private DefaultRelationshipTraversalCursor getSecurityRelationshipTraversalCursor() {
        if (this.securityRelationshipTraversalCursor == null) {
            this.securityRelationshipTraversalCursor = this.internalCursors.allocateRelationshipTraversalCursor();
        }
        return this.securityRelationshipTraversalCursor;
    }

    private AccessControlDataProvider getSelectedPropertiesProvider() {
        if (this.accessControlDataProvider == null) {
            this.accessControlDataProvider = new AccessControlDataProvider(() -> (propertyCursor, selection) -> {
                if (this.storeCursor.entityReference() != -1L) {
                    this.storeCursor.properties(propertyCursor, selection);
                }
            }, this.internalCursors, this.applyAccessModeToTxState, this::txStateProperties, () -> this.read);
        }
        return this.accessControlDataProvider;
    }

    private Iterable<StorageProperty> txStateProperties() {
        return this.txStateHolder.txState().getNodeState(this.nodeReference()).addedProperties();
    }

    private TokenSet labels(StorageNodeCursor nodeCursor) {
        if (this.currentAddedInChunk != -1L) {
            TransactionState txState = this.txStateHolder.txState();
            return Labels.from(txState.nodeStateLabelDiffSets(this.currentAddedInChunk).getAdded());
        }
        if (this.hasChanges()) {
            TransactionState txState = this.txStateHolder.txState();
            IntHashSet labels = new IntHashSet(nodeCursor.labels());
            return Labels.from((IntSet)txState.augmentLabels((MutableIntSet)labels, txState.getNodeState(nodeCursor.entityReference())));
        }
        return Labels.from(nodeCursor.labels());
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            while (this.addedNodes.hasNext()) {
                this.currentAddedInChunk = this.addedNodes.next();
                if (this.applyAccessModeToTxState && !this.allowsTraverse()) continue;
                this.traceNode();
                return true;
            }
            this.currentAddedInChunk = -1L;
        }
        while (this.storeCursor.next()) {
            if (this.deletedInThisBatch(hasChanges) || !this.allowsTraverse()) continue;
            this.traceNode();
            return true;
        }
        return false;
    }

    private boolean deletedInThisBatch(boolean hasChanges) {
        return hasChanges && this.txStateHolder.txState().nodeIsDeletedInThisBatch(this.storeCursor.entityReference());
    }

    private void traceNode() {
        if (this.tracer != null) {
            this.tracer.onNode(this.nodeReference());
        }
    }

    protected boolean allowsTraverse() {
        assert (this.accessMode == this.accessModeProvider.getAccessMode()) : "access mode changed while cursor is in use";
        return this.accessMode.allowsTraverseNode(() -> AccessControlDataProvider.nodeLabels(this, this.applyAccessModeToTxState), (SelectedPropertiesProvider)this.getSelectedPropertiesProvider());
    }

    protected boolean allowsTraverseAll() {
        assert (this.accessMode == this.accessModeProvider.getAccessMode()) : "access mode changed while cursor is in use";
        return this.accessMode.allowsTraverseAllRelTypes() && this.accessMode.allowsTraverseAllLabels();
    }

    @Override
    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            this.txStateHolder = null;
            this.accessModeProvider = null;
            this.accessMode = null;
            this.checkHasChanges = true;
            this.addedNodes = ImmutableEmptyLongIterator.INSTANCE;
            this.storeCursor.reset();
            if (this.securityRelationshipTraversalCursor != null) {
                this.securityRelationshipTraversalCursor.close();
                this.securityRelationshipTraversalCursor = null;
            }
            if (this.accessControlDataProvider != null) {
                this.accessControlDataProvider.close();
                this.accessControlDataProvider = null;
            }
        }
        super.closeInternal();
    }

    public boolean isClosed() {
        return this.read == null;
    }

    boolean hasChanges() {
        if (this.checkHasChanges) {
            this.hasChanges = this.txStateHolder.hasTxStateWithChanges();
            if (this.hasChanges) {
                this.addedNodes = this.collectTxStateChanges(this.txStateHolder);
            }
            this.checkHasChanges = false;
        }
        return this.hasChanges;
    }

    private LongIterator collectTxStateChanges(TxStateHolder stateHolder) {
        if (this.isSingle) {
            return stateHolder.txState().nodeIsAddedInThisBatch(this.single) ? PrimitiveLongCollections.single((long)this.single) : ImmutableEmptyLongIterator.INSTANCE;
        }
        return stateHolder.txState().addedAndRemovedNodes().getAdded().freeze().longIterator();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeCursor[closed state]";
        }
        return "NodeCursor[id=" + this.nodeReference() + ", " + String.valueOf(this.storeCursor) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        DefaultRelationshipTraversalCursor localSecurityRelationshipTraversalCursor = this.securityRelationshipTraversalCursor;
        AccessControlDataProvider localAccessControlDataProvider = this.accessControlDataProvider;
        try (DefaultRelationshipTraversalCursor defaultRelationshipTraversalCursor = localSecurityRelationshipTraversalCursor;
             AccessControlDataProvider accessControlDataProvider = localAccessControlDataProvider;
             StorageNodeCursor storageNodeCursor = this.storeCursor;){
            if (localSecurityRelationshipTraversalCursor != null) {
                localSecurityRelationshipTraversalCursor.release();
            }
            if (localAccessControlDataProvider != null) {
                localAccessControlDataProvider.release();
            }
        }
        finally {
            this.securityRelationshipTraversalCursor = null;
        }
    }
}

