/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Path;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;

public class MultiVersionTokenIndexUpdateStorage
implements Closeable {
    private final FileSystemAbstraction fs;
    private final Path file;
    private ScopedBuffer scopedBuffer;
    private final MemoryTracker memoryTracker;
    private ByteBuffer buffer;
    private StoreChannel storeChannel;
    private long entryCount;
    private volatile boolean allocated;

    MultiVersionTokenIndexUpdateStorage(FileSystemAbstraction fs, Path file, MemoryTracker memoryTracker) {
        this.fs = fs;
        this.file = file;
        this.memoryTracker = memoryTracker;
    }

    void add(long entityId, int[] added, int[] removed, long version) throws IOException {
        this.allocateResources();
        this.putLong(version);
        this.putLong(entityId);
        this.putInt(added.length);
        this.putInt(removed.length);
        for (int addedId : added) {
            this.putInt(addedId);
        }
        for (int removedId : removed) {
            this.putInt(removedId);
        }
        ++this.entryCount;
    }

    private void putLong(long value) throws IOException {
        this.ensureCapacity(8);
        this.buffer.putLong(value);
    }

    private void putInt(int value) throws IOException {
        this.ensureCapacity(4);
        this.buffer.putInt(value);
    }

    private void ensureCapacity(int bytes) throws IOException {
        if (this.buffer.remaining() < bytes) {
            this.buffer.flip();
            if (this.buffer.hasRemaining()) {
                this.storeChannel.writeAll(this.buffer);
            }
            this.buffer.clear();
        }
    }

    Reader reader() throws IOException {
        if (this.allocated) {
            this.flush();
        }
        return new Reader(this, this.entryCount);
    }

    @Override
    public void close() throws IOException {
        if (this.allocated) {
            IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.storeChannel, this.scopedBuffer, this::deleteFile, () -> {
                this.allocated = false;
            }});
        } else if (this.fs.fileExists(this.file)) {
            this.fs.deleteFile(this.file);
        }
    }

    private void allocateResources() throws IOException {
        if (!this.allocated) {
            this.storeChannel = this.fs.write(this.file);
            this.scopedBuffer = new NativeScopedBuffer(ByteUnit.kibiBytes((long)8L), ByteOrder.LITTLE_ENDIAN, this.memoryTracker);
            this.buffer = this.scopedBuffer.getBuffer();
            this.allocated = true;
        }
    }

    private void deleteFile() {
        try {
            this.fs.deleteFile(this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void flush() throws IOException {
        if (this.allocated) {
            this.buffer.flip();
            this.storeChannel.writeAll(this.buffer);
            this.buffer.clear();
        }
    }

    class Reader
    implements Closeable {
        private ReadAheadChannel<StoreChannel> channel = null;
        private long entriesLeft;
        long version;
        long entityId;
        int[] added;
        int[] removed;

        Reader(MultiVersionTokenIndexUpdateStorage this$0, long entryCount) throws IOException {
            if (entryCount > 0L) {
                this.channel = new ReadAheadChannel(this$0.fs.read(this$0.file), (ScopedBuffer)new NativeScopedBuffer(ByteUnit.kibiBytes((long)8L), ByteOrder.LITTLE_ENDIAN, this$0.memoryTracker));
            }
            this.entriesLeft = entryCount;
        }

        boolean next() throws IOException {
            int i;
            if (this.entriesLeft <= 0L) {
                return false;
            }
            this.version = this.channel.getLong();
            this.entityId = this.channel.getLong();
            int addedSize = this.channel.getInt();
            int removedSize = this.channel.getInt();
            this.added = new int[addedSize];
            this.removed = new int[removedSize];
            for (i = 0; i < addedSize; ++i) {
                this.added[i] = this.channel.getInt();
            }
            for (i = 0; i < removedSize; ++i) {
                this.removed[i] = this.channel.getInt();
            }
            --this.entriesLeft;
            return true;
        }

        @Override
        public void close() throws IOException {
            if (this.channel != null) {
                this.channel.close();
            }
        }
    }
}

