/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.List;
import java.util.Map;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.BaseNodeConstraintCreator;
import org.neo4j.kernel.impl.coreapi.schema.IndexCreatorImpl;
import org.neo4j.kernel.impl.coreapi.schema.IndexDefinitionImpl;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class NodeKeyConstraintCreator
extends BaseNodeConstraintCreator {
    private final List<String> propertyKeys;

    NodeKeyConstraintCreator(InternalSchemaActions actions, String name, Label label, List<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        super(actions, name, label, indexType, indexConfig);
        this.propertyKeys = propertyKeys;
    }

    @Override
    public ConstraintCreator assertPropertyIsUnique(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one unique constraint at a time.");
    }

    @Override
    public ConstraintCreator assertPropertyExists(String propertyKey) {
        throw new UnsupportedOperationException("You can only create one property existence constraint at a time.");
    }

    @Override
    public ConstraintCreator assertPropertyIsNodeKey(String propertyKey) {
        return new NodeKeyConstraintCreator(this.actions, this.name, this.label, IndexCreatorImpl.copyAndAppend(this.propertyKeys, propertyKey), this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator assertPropertyHasType(String propertyKey, PropertyType ... propertyType) {
        throw new UnsupportedOperationException("You cannot create a property type constraint together with other constraints.");
    }

    @Override
    public ConstraintCreator withName(String name) {
        return new NodeKeyConstraintCreator(this.actions, name, this.label, this.propertyKeys, this.indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexType(IndexType indexType) {
        return new NodeKeyConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, indexType, this.indexConfig);
    }

    @Override
    public ConstraintCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        return new NodeKeyConstraintCreator(this.actions, this.name, this.label, this.propertyKeys, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    @Override
    public ConstraintDefinition create() {
        this.assertInUnterminatedTransaction();
        IndexDefinitionImpl index = new IndexDefinitionImpl(this.actions, null, new Label[]{this.label}, this.propertyKeys.toArray(new String[0]), true);
        return this.actions.createNodeKeyConstraint(index, this.name, this.indexType, this.indexConfig);
    }
}

