/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingUtil;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;

public class IndexCreatorImpl
implements IndexCreator {
    private final List<String> propertyKeys;
    private final Label[] labels;
    private final RelationshipType[] types;
    private final InternalSchemaActions actions;
    private final String indexName;
    private final IndexType indexType;
    private final IndexConfig indexConfig;

    public IndexCreatorImpl(InternalSchemaActions actions, Label ... labels) {
        this(actions, labels, null, null, Collections.emptyList(), IndexType.RANGE, IndexConfig.empty());
    }

    public IndexCreatorImpl(InternalSchemaActions actions, RelationshipType ... types) {
        this(actions, null, types, null, Collections.emptyList(), IndexType.RANGE, IndexConfig.empty());
    }

    private IndexCreatorImpl(InternalSchemaActions actions, Label[] labels, RelationshipType[] types, String indexName, List<String> propertyKeys, IndexType indexType, IndexConfig indexConfig) {
        this.actions = actions;
        this.labels = labels;
        this.types = types;
        this.indexName = indexName;
        this.propertyKeys = propertyKeys;
        this.indexType = indexType;
        this.indexConfig = indexConfig;
        this.assertInUnterminatedTransaction();
    }

    public IndexCreator on(String propertyKey) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.labels, this.types, this.indexName, IndexCreatorImpl.copyAndAppend(this.propertyKeys, propertyKey), this.indexType, this.indexConfig);
    }

    public IndexCreator withName(String indexName) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.labels, this.types, indexName, this.propertyKeys, this.indexType, this.indexConfig);
    }

    public IndexCreator withIndexType(IndexType indexType) {
        this.assertInUnterminatedTransaction();
        if (indexType == IndexType.LOOKUP) {
            throw new ConstraintViolationException("Index type " + String.valueOf(indexType) + " is not supported for property indexes.");
        }
        return new IndexCreatorImpl(this.actions, this.labels, this.types, this.indexName, this.propertyKeys, indexType, this.indexConfig);
    }

    public IndexCreator withIndexConfiguration(Map<IndexSetting, Object> indexConfiguration) {
        this.assertInUnterminatedTransaction();
        return new IndexCreatorImpl(this.actions, this.labels, this.types, this.indexName, this.propertyKeys, this.indexType, IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(indexConfiguration));
    }

    public IndexDefinition create() throws ConstraintViolationException {
        this.assertInUnterminatedTransaction();
        if (this.propertyKeys.isEmpty()) {
            throw new ConstraintViolationException("An index needs at least one property key to index");
        }
        if (this.labels != null) {
            return this.actions.createIndexDefinition(this.labels, this.indexName, this.indexType, this.indexConfig, this.propertyKeys.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        if (this.types != null) {
            return this.actions.createIndexDefinition(this.types, this.indexName, this.indexType, this.indexConfig, this.propertyKeys.toArray(ArrayUtils.EMPTY_STRING_ARRAY));
        }
        throw new IllegalStateException("Must have either labels or relationship types to create an index, but neither was present.");
    }

    private void assertInUnterminatedTransaction() {
        this.actions.assertInOpenTransaction();
    }

    static List<String> copyAndAppend(List<String> propertyKeys, String propertyKey) {
        ArrayList<String> ret = new ArrayList<String>(propertyKeys);
        ret.addLast(propertyKey);
        return ret;
    }
}

