/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.constraints;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeLabelIndexCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.exceptions.schema.CreateConstraintFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.GraphTypeDependence;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.KeyConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.internal.schema.constraints.RelationshipEndpointLabelConstraintDescriptor;
import org.neo4j.internal.schema.constraints.TypeConstraintDescriptor;
import org.neo4j.internal.schema.constraints.UniquenessConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.constraints.ConstraintSemantics;
import org.neo4j.kernel.impl.newapi.FilteringNodeCursorWrapper;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.StandardConstraintRuleAccessor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

public class StandardConstraintSemantics
extends ConstraintSemantics {
    public static final String ERROR_MESSAGE_EXISTS = "Property existence constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_KEY_SUFFIX = "Key constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_TYPE = "Property type constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_RELATIONSHIP_ENDPOINT_LABEL = "Relationship endpoint label constraint requires Neo4j Enterprise Edition";
    public static final String ERROR_MESSAGE_NODE_LABEL_EXISTENCE = "Node label existence constraint requires Neo4j Enterprise Edition";
    protected final StandardConstraintRuleAccessor accessor = new StandardConstraintRuleAccessor();

    public StandardConstraintSemantics() {
        this(Integer.MAX_VALUE);
    }

    protected StandardConstraintSemantics(int priority) {
        super(priority);
    }

    @Override
    public void assertKeyConstraintAllowed(SchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateNodeKeyConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup);
    }

    @Override
    public void validateRelKeyConstraint(RelationshipTypeIndexCursor allRelationships, RelationshipScanCursor relCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup);
    }

    @Override
    public void validateNodePropertyExistenceConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup, isDependent);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(FilteringRelationshipScanCursorWrapper relationshipCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup, isDependent);
    }

    @Override
    public void validateRelationshipPropertyExistenceConstraint(RelationshipTypeIndexCursor allRelationships, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup, isDependent);
    }

    public ConstraintDescriptor readConstraint(ConstraintDescriptor constraint) {
        switch (constraint.type()) {
            default: {
                throw new MatchException(null, null);
            }
            case UNIQUE: {
                break;
            }
            case EXISTS: {
                throw new IllegalStateException(ERROR_MESSAGE_EXISTS);
            }
            case UNIQUE_EXISTS: {
                throw new IllegalStateException(StandardConstraintSemantics.keyConstraintErrorMessage(constraint.schema()));
            }
            case PROPERTY_TYPE: {
                throw new IllegalStateException(ERROR_MESSAGE_TYPE);
            }
            case RELATIONSHIP_ENDPOINT_LABEL: {
                throw new IllegalStateException(ERROR_MESSAGE_RELATIONSHIP_ENDPOINT_LABEL);
            }
            case NODE_LABEL_EXISTENCE: {
                throw new IllegalStateException(ERROR_MESSAGE_NODE_LABEL_EXISTENCE);
            }
        }
        return constraint;
    }

    private static CreateConstraintFailureException propertyExistenceConstraintsNotAllowed(SchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent) {
        return CreateConstraintFailureException.constraintCreationFailedOnCommunity((ConstraintDescriptor)ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)descriptor, (boolean)isDependent), (TokenNameLookup)tokenNameLookup, (String)ERROR_MESSAGE_EXISTS);
    }

    private static CreateConstraintFailureException propertyTypeConstraintsNotAllowed(TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return CreateConstraintFailureException.constraintCreationFailedOnCommunity((ConstraintDescriptor)descriptor, (TokenNameLookup)tokenNameLookup, (String)ERROR_MESSAGE_TYPE);
    }

    private static CreateConstraintFailureException relationshipEndpointLabelConstraintsNotAllowed(RelationshipEndpointLabelConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return CreateConstraintFailureException.constraintCreationFailedOnCommunity((ConstraintDescriptor)descriptor, (TokenNameLookup)tokenNameLookup, (String)ERROR_MESSAGE_RELATIONSHIP_ENDPOINT_LABEL);
    }

    private static CreateConstraintFailureException nodeLabelExistenceConstraintsNotAllowed(NodeLabelExistenceConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return CreateConstraintFailureException.constraintCreationFailedOnCommunity((ConstraintDescriptor)descriptor, (TokenNameLookup)tokenNameLookup, (String)ERROR_MESSAGE_NODE_LABEL_EXISTENCE);
    }

    private static String keyConstraintErrorMessage(SchemaDescriptor descriptor) {
        return (descriptor.entityType() == EntityType.NODE ? "Node " : "Relationship ") + ERROR_MESSAGE_KEY_SUFFIX;
    }

    private static CreateConstraintFailureException keyConstraintsNotAllowed(SchemaDescriptor descriptor, TokenNameLookup tokenNameLookup) {
        return CreateConstraintFailureException.constraintCreationFailedOnCommunity((ConstraintDescriptor)ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)descriptor), (TokenNameLookup)tokenNameLookup, (String)StandardConstraintSemantics.keyConstraintErrorMessage(descriptor));
    }

    public ConstraintDescriptor createUniquenessConstraintRule(long ruleId, UniquenessConstraintDescriptor descriptor, long indexId) {
        return this.accessor.createUniquenessConstraintRule(ruleId, descriptor, indexId);
    }

    public ConstraintDescriptor createKeyConstraintRule(long ruleId, KeyConstraintDescriptor descriptor, long indexId, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed(descriptor.schema(), tokenNameLookup);
    }

    public ConstraintDescriptor createExistenceConstraint(long ruleId, ConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed(descriptor.schema(), tokenNameLookup, descriptor.graphTypeDependence() == GraphTypeDependence.DEPENDENT);
    }

    public ConstraintDescriptor createPropertyTypeConstraint(long ruleId, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    public ConstraintDescriptor createRelationshipEndpointLabelConstraint(long ruleId, RelationshipEndpointLabelConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.relationshipEndpointLabelConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    public ConstraintDescriptor createNodeLabelExistenceConstraint(long ruleId, NodeLabelExistenceConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.nodeLabelExistenceConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public TxStateVisitor decorateTxStateVisitor(StorageReader storageReader, Read read, CursorFactory cursorFactory, ReadableTransactionState state, TxStateVisitor visitor, CursorContext cursorContext, MemoryTracker memoryTracker) {
        return visitor;
    }

    @Override
    public void validateNodePropertyExistenceConstraint(FilteringNodeCursorWrapper nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, boolean isDependent, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyExistenceConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup, isDependent);
    }

    @Override
    public void validateNodeKeyConstraint(FilteringNodeCursorWrapper nodeCursor, PropertyCursor propertyCursor, LabelSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup);
    }

    @Override
    public void validateRelKeyConstraint(FilteringRelationshipScanCursorWrapper relCursor, PropertyCursor propertyCursor, RelationTypeSchemaDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.keyConstraintsNotAllowed((SchemaDescriptor)descriptor, tokenNameLookup);
    }

    @Override
    public void validateNodePropertyTypeConstraint(FilteringNodeCursorWrapper nodeCursor, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateNodePropertyTypeConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateRelationshipPropertyTypeConstraint(FilteringRelationshipScanCursorWrapper relationshipCursor, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateRelationshipPropertyTypeConstraint(RelationshipTypeIndexCursor allRelationships, PropertyCursor propertyCursor, TypeConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup, MemoryTracker memoryTracker) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.propertyTypeConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateRelationshipEndpointLabelConstraint(RelationshipScanCursor relCursor, NodeCursor nodeCursor, RelationshipEndpointLabelConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.relationshipEndpointLabelConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateRelationshipEndpointLabelConstraint(RelationshipTypeIndexCursor relCursor, NodeCursor nodeCursor, RelationshipEndpointLabelConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.relationshipEndpointLabelConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateNodeLabelExistenceConstraint(NodeLabelIndexCursor allNodes, NodeCursor nodeCursor, NodeLabelExistenceConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.nodeLabelExistenceConstraintsNotAllowed(descriptor, tokenNameLookup);
    }

    @Override
    public void validateNodeLabelExistenceConstraint(NodeCursor nodeCursor, NodeLabelExistenceConstraintDescriptor descriptor, TokenNameLookup tokenNameLookup) throws CreateConstraintFailureException {
        throw StandardConstraintSemantics.nodeLabelExistenceConstraintsNotAllowed(descriptor, tokenNameLookup);
    }
}

