/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.state;

import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.PropertyKeyValue;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

class EntityStateImpl
implements EntityState {
    private final long id;
    private MutableLongObjectMap<Value> addedProperties;
    private MutableLongSet removedProperties;
    final CollectionsFactory collectionsFactory;
    final MemoryTracker memoryTracker;

    EntityStateImpl(long id, CollectionsFactory collectionsFactory, MemoryTracker memoryTracker) {
        this.id = id;
        this.collectionsFactory = Objects.requireNonNull(collectionsFactory);
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
    }

    public long getId() {
        return this.id;
    }

    void clear() {
        if (this.addedProperties != null) {
            this.addedProperties.clear();
        }
        if (this.removedProperties != null) {
            this.removedProperties.clear();
        }
    }

    void addProperty(int propertyKeyId, Value value) {
        if (this.removedProperties != null) {
            this.removedProperties.remove((long)propertyKeyId);
        }
        if (this.addedProperties == null) {
            this.addedProperties = this.collectionsFactory.newObjectMap(this.memoryTracker);
        }
        this.addedProperties.put((long)propertyKeyId, (Object)value);
    }

    boolean removePropertyFromTxState(int propertyKeyId) {
        if (this.addedProperties != null) {
            return this.addedProperties.remove((long)propertyKeyId) != null;
        }
        return false;
    }

    void removePropertyFromStore(int propertyKeyId) {
        if (this.removedProperties == null) {
            this.removedProperties = this.collectionsFactory.newLongSet(this.memoryTracker);
        }
        this.removedProperties.add((long)propertyKeyId);
    }

    public Iterable<StorageProperty> addedProperties() {
        return EntityStateImpl.toStorageProperties(this.addedProperties);
    }

    public IntIterable removedProperties() {
        return this.removedProperties == null ? IntSets.immutable.empty() : this.removedProperties.asLazy().collectInt(Math::toIntExact);
    }

    public boolean hasPropertyChanges() {
        return this.addedProperties != null && !this.addedProperties.isEmpty() || this.removedProperties != null && !this.removedProperties.isEmpty();
    }

    public boolean isPropertyChangedOrRemoved(int propertyKey) {
        return this.removedProperties != null && this.removedProperties.contains((long)propertyKey) || this.addedProperties != null && this.addedProperties.containsKey((long)propertyKey);
    }

    public boolean isPropertyAdded(int propertyKey) {
        return this.addedProperties != null && this.addedProperties.containsKey((long)propertyKey);
    }

    public Value propertyValue(int propertyKey) {
        Value addedValue;
        if (this.removedProperties != null && this.removedProperties.contains((long)propertyKey)) {
            return Values.NO_VALUE;
        }
        if (this.addedProperties != null && (addedValue = (Value)this.addedProperties.get((long)propertyKey)) != null) {
            return addedValue;
        }
        return null;
    }

    private static Iterable<StorageProperty> toStorageProperties(LongObjectMap<Value> propertyMap) {
        return propertyMap == null ? Collections.emptyList() : propertyMap.keyValuesView().collect((Function & Serializable)e -> new PropertyKeyValue(Math.toIntExact(e.getOne()), (Value)e.getTwo()));
    }
}

