/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.drop;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.impl.factory.Multimaps;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.drop.IndexDropController;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.util.VisibleForTesting;

public final class MultiVersionIndexDropController
extends LifecycleAdapter
implements IndexDropController {
    private static final int TRIGGER_THRESHOLD = 10;
    private final ConcurrentLinkedDeque<IndexDropRequest> asyncDeleteQueue;
    private final JobScheduler jobScheduler;
    private final IndexingService indexingService;
    private final IndexMonitor monitor;
    private final TransactionVisibilityProvider transactionVisibilityProvider;
    private final Log log;
    private JobHandle<?> asyncDropJobHandle;
    private final FileSystemAbstraction fs;
    private final Duration maintenanceInterval;

    public MultiVersionIndexDropController(JobScheduler jobScheduler, TransactionVisibilityProvider visibilityProvider, IndexingService indexingService, FileSystemAbstraction fs, LogProvider logProvider, IndexMonitor monitor, Config config) {
        this.jobScheduler = jobScheduler;
        this.indexingService = indexingService;
        this.monitor = monitor;
        this.asyncDeleteQueue = new ConcurrentLinkedDeque();
        this.transactionVisibilityProvider = visibilityProvider;
        this.fs = fs;
        this.log = logProvider.getLog(MultiVersionIndexDropController.class);
        this.maintenanceInterval = (Duration)config.get(GraphDatabaseInternalSettings.async_index_drop_maintenance_interval);
    }

    public void start() {
        this.cleanupLeftOvers();
        this.asyncDropJobHandle = this.jobScheduler.scheduleRecurring(Group.STORAGE_MAINTENANCE, this::maintenance, this.maintenanceInterval.toSeconds(), this.maintenanceInterval.toSeconds(), TimeUnit.SECONDS);
    }

    private void cleanupLeftOvers() {
        try {
            Collection<IndexProvider> providers = this.indexingService.getIndexProviders();
            Map<String, IndexProvider> providersMap = providers.stream().collect(Collectors.toMap(indexProvider -> indexProvider.getProviderDescriptor().name(), indexProvider -> indexProvider));
            MutableSetMultimap pathMultimap = Multimaps.mutable.set.empty();
            for (IndexProvider provider : providers) {
                Path[] indexDirectories;
                Path directory = provider.directoryStructure().rootDirectory();
                if (!this.fs.fileExists(directory)) continue;
                for (Path indexDirectory : indexDirectories = this.fs.listFiles(directory)) {
                    pathMultimap.put((Object)provider, (Object)indexDirectory);
                }
            }
            this.indexingService.getIndexProxies().forEach(indexProxy -> {
                IndexProvider provider = (IndexProvider)providersMap.get(indexProxy.getDescriptor().getIndexProvider().name());
                Path path = provider.directoryStructure().directoryForIndex(indexProxy.getDescriptor().getId());
                pathMultimap.remove((Object)provider, (Object)path);
            });
            pathMultimap.forEachValue((Procedure & Serializable)path -> {
                try {
                    this.fs.deleteRecursively(path);
                }
                catch (IOException e) {
                    this.log.warn("Failed to remove index directory: " + String.valueOf(path), (Throwable)e);
                }
            });
        }
        catch (Exception e) {
            this.log.error("Fail to clean up index leftovers.", (Throwable)e);
        }
    }

    public void stop() {
        if (this.asyncDropJobHandle != null) {
            this.asyncDropJobHandle.cancel();
        }
    }

    @Override
    public void dropIndex(IndexDescriptor descriptor) {
        this.asyncDeleteQueue.add(new IndexDropRequest(descriptor, this.transactionVisibilityProvider.youngestObservableHorizon()));
        if (this.asyncDeleteQueue.size() > 10) {
            this.jobScheduler.schedule(Group.STORAGE_MAINTENANCE, this::maintenance);
        }
    }

    @Override
    public synchronized void maintenance() {
        long oldestBoundary = this.transactionVisibilityProvider.oldestObservableHorizon();
        IndexDropRequest request = this.asyncDeleteQueue.peek();
        while (request != null) {
            if (request.highestOpenedTransaction() < oldestBoundary) {
                this.safeIndexDrop(request);
                this.asyncDeleteQueue.remove(request);
                request = this.asyncDeleteQueue.peek();
                continue;
            }
            request = null;
        }
    }

    @VisibleForTesting
    ConcurrentLinkedDeque<IndexDropRequest> getAsyncDeleteQueue() {
        return this.asyncDeleteQueue;
    }

    private void safeIndexDrop(IndexDropRequest request) {
        try {
            this.indexingService.internalIndexDrop(request.descriptor);
        }
        catch (Exception e) {
            this.log.error("Exception on multi version index async drop.", (Throwable)e);
        }
    }

    private record IndexDropRequest(IndexDescriptor descriptor, long highestOpenedTransaction) {
    }
}

