/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.api.chunk.ChunkMetadata;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.Leases;
import org.neo4j.storageengine.api.StorageCommand;

public record ChunkedCommandBatch(List<StorageCommand> commands, ChunkMetadata chunkMetadata) implements CommandBatch
{
    public long consensusIndex() {
        return this.chunkMetadata.consensusIndex().longValue();
    }

    public long getTimeStarted() {
        return this.chunkMetadata.startTimeMillis();
    }

    public long getLatestCommittedTxWhenStarted() {
        return this.chunkMetadata.lastTransactionIdWhenStarted();
    }

    public long getTimeCommitted() {
        return this.chunkMetadata.chunkCommitTime();
    }

    public int getLeaseId() {
        return this.chunkMetadata.leaseId();
    }

    public Leases leases() {
        return Leases.NO_LEASES;
    }

    public Subject subject() {
        return this.chunkMetadata.subject();
    }

    public KernelVersion kernelVersion() {
        return this.chunkMetadata.kernelVersion();
    }

    public String toString(boolean includeCommands) {
        return "CommandChunk{commands=" + String.valueOf(this.commands) + ", chunkMetadata=" + String.valueOf(this.chunkMetadata) + "}";
    }

    public boolean isLast() {
        return this.chunkMetadata.last();
    }

    public boolean isFirst() {
        return this.chunkMetadata.first();
    }

    public boolean isRollback() {
        return this.chunkMetadata.rollback();
    }

    public boolean accept(Visitor<StorageCommand, IOException> visitor) throws IOException {
        for (StorageCommand command : this.commands) {
            if (!visitor.visit((Object)command)) continue;
            return true;
        }
        return false;
    }

    public Iterator<StorageCommand> iterator() {
        return this.commands.iterator();
    }

    public int commandCount() {
        return this.commands.size();
    }

    public long appendIndex() {
        long appendIndex = this.chunkMetadata.appendIndex().longValue();
        if (appendIndex == 0L) {
            throw new IllegalStateException("Append index was not generated for the batch yet.");
        }
        return appendIndex;
    }

    public void setAppendIndex(long appendIndex) {
        this.chunkMetadata.appendIndex().setValue(appendIndex);
    }

    public void setConsensusIndex(long commandIndex) {
        this.chunkMetadata.consensusIndex().setValue(commandIndex);
    }
}

