/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.kernel.api.query.IndexUsage;
import org.neo4j.util.Preconditions;

public class SchemaIndexUsage
extends IndexUsage {
    private final String[] labels;
    private final String[] propertyKeys;
    private final int[] propertyKeyIds;
    private final int[] labelIds;

    public SchemaIndexUsage(String identifier, int[] labelIds, String[] labels, int[] propertyKeyIds, String[] propertyKeys) {
        super(identifier);
        Preconditions.checkArgument((labelIds.length == labels.length ? 1 : 0) != 0, (String)"label names and ids must match");
        this.labels = labels;
        this.labelIds = labelIds;
        this.propertyKeys = propertyKeys;
        this.propertyKeyIds = propertyKeyIds;
    }

    public int[] getLabelIds() {
        return this.labelIds;
    }

    public int[] getPropertyKeys() {
        return this.propertyKeyIds;
    }

    @Override
    public Map<String, String> asMap() {
        int i;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("indexType", "SCHEMA INDEX");
        map.put("entityType", "NODE");
        map.put("identifier", this.identifier);
        for (i = 0; i < this.labels.length; ++i) {
            Object labelKey = this.labels.length > 1 ? "label_" + i : "label";
            Object labelIdKey = this.labels.length > 1 ? "labelId_" + i : "labelId";
            map.put((String)labelKey, this.labels[i]);
            map.put((String)labelIdKey, String.valueOf(this.labelIds[i]));
        }
        for (i = 0; i < this.propertyKeys.length; ++i) {
            Object key = this.propertyKeys.length > 1 ? "propertyKey_" + i : "propertyKey";
            map.put((String)key, this.propertyKeys[i]);
        }
        return map;
    }
}

