/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.InputPosition;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.DeprecationNotificationsProvider;
import org.neo4j.kernel.api.query.ExecutingQuery;
import org.neo4j.kernel.api.query.IndexUsage;
import org.neo4j.kernel.api.query.QueryCacheUsage;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.lock.ActiveLock;
import org.neo4j.values.virtual.MapValue;

public class QuerySnapshot {
    private final ExecutingQuery query;
    private final CompilerInfo compilerInfo;
    private final long compilationTimeMicros;
    private final long elapsedTimeMicros;
    private final long cpuTimeMicros;
    private final long waitTimeMicros;
    private final String status;
    private final Map<String, Object> resourceInfo;
    private final List<ActiveLock> waitingLocks;
    private final long activeLockCount;
    private final long allocatedBytes;
    private final long pageHits;
    private final long pageFaults;
    private final Optional<String> obfuscatedQueryText;
    private final Optional<Function<InputPosition, InputPosition>> obfuscatePosition;
    private final Optional<MapValue> obfuscatedQueryParameters;
    private final CypherVersion queryLanguage;
    private final long transactionSequenceNumber;
    private final long parentTransactionSequenceNumber;
    private final String parentDbName;
    private final QueryCacheUsage executableQueryCacheUsage;
    private final QueryCacheUsage logicalPlanCacheUsage;
    private final int executionPlanCacheKeyHash;

    QuerySnapshot(ExecutingQuery query, CompilerInfo compilerInfo, long pageHits, long pageFaults, long compilationTimeMicros, long elapsedTimeMicros, long cpuTimeMicros, long waitTimeMicros, String status, Map<String, Object> resourceInfo, List<ActiveLock> waitingLocks, long activeLockCount, long allocatedBytes, Optional<String> obfuscatedQueryText, Optional<Function<InputPosition, InputPosition>> obfuscatePosition, Optional<MapValue> obfuscatedQueryParameters, CypherVersion queryLanguage, long outerTransactionSequenceNumber, String parentDbName, long parentTransactionSequenceNumber, QueryCacheUsage executableQueryCacheUsage, QueryCacheUsage logicalPlanCacheUsage, int executionPlanCacheKeyHash) {
        this.query = query;
        this.compilerInfo = compilerInfo;
        this.pageHits = pageHits;
        this.pageFaults = pageFaults;
        this.compilationTimeMicros = compilationTimeMicros;
        this.elapsedTimeMicros = elapsedTimeMicros;
        this.cpuTimeMicros = cpuTimeMicros;
        this.waitTimeMicros = waitTimeMicros;
        this.status = status;
        this.resourceInfo = resourceInfo;
        this.waitingLocks = waitingLocks;
        this.activeLockCount = activeLockCount;
        this.allocatedBytes = allocatedBytes;
        this.obfuscatedQueryText = obfuscatedQueryText;
        this.obfuscatePosition = obfuscatePosition;
        this.obfuscatedQueryParameters = obfuscatedQueryParameters;
        this.queryLanguage = queryLanguage;
        this.transactionSequenceNumber = outerTransactionSequenceNumber;
        this.parentDbName = parentDbName;
        this.parentTransactionSequenceNumber = parentTransactionSequenceNumber;
        this.executableQueryCacheUsage = executableQueryCacheUsage;
        this.logicalPlanCacheUsage = logicalPlanCacheUsage;
        this.executionPlanCacheKeyHash = executionPlanCacheKeyHash;
    }

    public long internalQueryId() {
        return this.query.internalQueryId();
    }

    public String id() {
        return this.query.id();
    }

    public String rawQueryText() {
        return this.query.rawQueryText();
    }

    public Optional<String> obfuscatedQueryText() {
        return this.obfuscatedQueryText;
    }

    public Optional<Function<InputPosition, InputPosition>> obfuscatePosition() {
        return this.obfuscatePosition;
    }

    public MapValue rawQueryParameters() {
        return this.query.rawQueryParameters();
    }

    public Optional<MapValue> obfuscatedQueryParameters() {
        return this.obfuscatedQueryParameters;
    }

    public CypherVersion queryLanguage() {
        return this.queryLanguage;
    }

    public Supplier<ExecutionPlanDescription> queryPlanSupplier() {
        return this.query.planDescriptionSupplier();
    }

    public DeprecationNotificationsProvider deprecationNotificationsProvider() {
        return this.query.getDeprecationNotificationsProvider();
    }

    public DeprecationNotificationsProvider fabricDeprecationNotificationsProvider() {
        return this.query.getFabricDeprecationNotificationsProvider();
    }

    public String executingUsername() {
        return this.query.executingUsername();
    }

    public String authenticatedUsername() {
        return this.query.authenticatedUsername();
    }

    public Optional<NamedDatabaseId> databaseId() {
        return this.query.databaseId();
    }

    public ClientConnectionInfo clientConnection() {
        return this.query.clientConnection();
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.query.transactionAnnotationData();
    }

    public long activeLockCount() {
        return this.activeLockCount;
    }

    public String planner() {
        return this.compilerInfo == null ? null : this.compilerInfo.planner();
    }

    public String runtime() {
        return this.compilerInfo == null ? null : this.compilerInfo.runtime();
    }

    public List<Map<String, String>> indexes() {
        if (this.compilerInfo == null) {
            return Collections.emptyList();
        }
        return Stream.concat(this.compilerInfo.indexes().stream(), this.compilerInfo.relationshipTypeIndexes().stream()).map(IndexUsage::asMap).toList();
    }

    public String status() {
        return this.status;
    }

    public Map<String, Object> resourceInformation() {
        return this.resourceInfo;
    }

    public long startTimestampMillis() {
        return this.query.startTimestampMillis();
    }

    public long transactionSequenceNumber() {
        return this.transactionSequenceNumber;
    }

    public long compilationTimeMicros() {
        return this.compilationTimeMicros;
    }

    public long waitTimeMicros() {
        return this.waitTimeMicros;
    }

    public long elapsedTimeMicros() {
        return this.elapsedTimeMicros;
    }

    public OptionalLong cpuTimeMicros() {
        return this.cpuTimeMicros < 0L ? OptionalLong.empty() : OptionalLong.of(this.cpuTimeMicros);
    }

    public OptionalLong idleTimeMicros() {
        return this.cpuTimeMicros < 0L ? OptionalLong.empty() : OptionalLong.of(this.elapsedTimeMicros - this.cpuTimeMicros - this.waitTimeMicros);
    }

    public long allocatedBytes() {
        return this.allocatedBytes;
    }

    public long pageHits() {
        return this.pageHits;
    }

    public long pageFaults() {
        return this.pageFaults;
    }

    public List<ActiveLock> waitingLocks() {
        return this.waitingLocks;
    }

    public String parentDbName() {
        return this.parentDbName;
    }

    public long parentTransactionSequenceNumber() {
        return this.parentTransactionSequenceNumber;
    }

    public Optional<QueryCacheUsage> executableQueryCacheUsage() {
        return Optional.ofNullable(this.executableQueryCacheUsage);
    }

    public Optional<QueryCacheUsage> logicalPlanCacheUsage() {
        return Optional.ofNullable(this.logicalPlanCacheUsage);
    }

    public int executionPlanCacheKeyHash() {
        return this.executionPlanCacheKeyHash;
    }
}

