/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.database.transaction;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.locks.Lock;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.neo4j.io.fs.DelegatingStoreChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.database.transaction.LogChannel;
import org.neo4j.kernel.api.database.transaction.TransactionLogChannels;
import org.neo4j.kernel.api.database.transaction.TransactionLogService;
import org.neo4j.kernel.availability.AvailabilityGuard;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.AppendedChunkLogVersionLocator;
import org.neo4j.kernel.impl.transaction.log.AppendedChunkPositionLocator;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogicalTransactionStore;
import org.neo4j.kernel.impl.transaction.log.NoSuchLogEntryException;
import org.neo4j.kernel.impl.transaction.log.checkpoint.CheckPointer;
import org.neo4j.kernel.impl.transaction.log.checkpoint.SimpleTriggerInfo;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.util.Preconditions;

public class TransactionLogServiceImpl
implements TransactionLogService {
    private final LogicalTransactionStore transactionStore;
    private final LogMetadataProvider metadataProvider;
    private final Lock pruneLock;
    private final LogFile logFile;
    private final AvailabilityGuard availabilityGuard;
    private final InternalLog log;
    private final CheckPointer checkPointer;
    private final CommandReaderFactory commandReaderFactory;
    private final BinarySupportedKernelVersions binarySupportedKernelVersions;

    public TransactionLogServiceImpl(LogMetadataProvider metadataProvider, LogFiles logFiles, LogicalTransactionStore transactionStore, Lock pruneLock, AvailabilityGuard availabilityGuard, InternalLogProvider logProvider, CheckPointer checkPointer, CommandReaderFactory commandReaderFactory, BinarySupportedKernelVersions binarySupportedKernelVersions) {
        this.metadataProvider = metadataProvider;
        this.transactionStore = transactionStore;
        this.pruneLock = pruneLock;
        this.logFile = logFiles.getLogFile();
        this.availabilityGuard = availabilityGuard;
        this.log = logProvider.getLog(this.getClass());
        this.checkPointer = checkPointer;
        this.commandReaderFactory = commandReaderFactory;
        this.binarySupportedKernelVersions = binarySupportedKernelVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionLogChannels logFilesChannels(long startAppendIndex) throws IOException {
        Preconditions.requirePositive((long)startAppendIndex);
        LogPosition minimalLogPosition = this.getLogPosition(startAppendIndex);
        this.pruneLock.lock();
        try {
            long minimalVersion = minimalLogPosition.getLogVersion();
            AppendBatchInfo lastAppendBatch = this.getLastAppendBatch();
            ArrayList<LogChannel> channels = this.collectChannels(startAppendIndex, minimalLogPosition, minimalVersion, lastAppendBatch.appendIndex(), lastAppendBatch.logPositionAfter());
            TransactionLogChannels transactionLogChannels = new TransactionLogChannels(channels);
            return transactionLogChannels;
        }
        finally {
            this.pruneLock.unlock();
        }
    }

    @Override
    public LogPosition append(ByteBuffer byteBuffer, OptionalLong appendIndex, Optional<Byte> kernelVersionByte, int checksum, long offset, Optional<Byte> logFormatByte) throws IOException {
        Preconditions.checkState((!this.availabilityGuard.isAvailable() ? 1 : 0) != 0, (String)"Database should not be available.");
        return this.logFile.append(byteBuffer, appendIndex, kernelVersionByte, checksum, offset, logFormatByte);
    }

    @Override
    public void restore(LogPosition position) throws IOException {
        Preconditions.checkState((!this.availabilityGuard.isAvailable() ? 1 : 0) != 0, (String)"Database should not be available.");
        this.logFile.truncate(position);
    }

    @Override
    public void appendCheckpoint(TransactionId transactionId, long appendIndex, String reason) throws IOException {
        Preconditions.checkState((!this.availabilityGuard.isAvailable() ? 1 : 0) != 0, (String)"Database should not be available.");
        long appendIndexToLookup = appendIndex + 1L;
        LogHeader logHeader = Objects.requireNonNull(this.logFile.extractHeader(this.logFile.getLogRangeInfo().highestVersion()));
        LogPosition lastHeaderPosition = logHeader.getStartPosition();
        AppendedChunkLogVersionLocator versionLocator = new AppendedChunkLogVersionLocator(appendIndexToLookup);
        this.logFile.accept(versionLocator);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader(this.commandReaderFactory, this.binarySupportedKernelVersions, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
        AppendedChunkPositionLocator transactionPositionLocator = new AppendedChunkPositionLocator(appendIndexToLookup, (LogEntryReader)logEntryReader);
        this.logFile.accept(transactionPositionLocator, versionLocator.getOptionalLogPosition().orElse(lastHeaderPosition));
        LogPosition position = transactionPositionLocator.getLogPositionOrThrow();
        this.log.info("Writing checkpoint to force recovery from append index:`%d` from specific position:`%s` with transaction id:'%s'.", new Object[]{appendIndex, position, transactionId});
        this.checkPointer.forceCheckPoint(transactionId, appendIndex, position, new SimpleTriggerInfo(reason));
    }

    private AppendBatchInfo getLastAppendBatch() throws IOException {
        AppendBatchInfo lastBatchInfo = this.metadataProvider.getLastCommittedBatch();
        if (!LogPosition.UNSPECIFIED.equals((Object)lastBatchInfo.logPositionAfter())) {
            return lastBatchInfo;
        }
        return this.getAppendBatchInfo(lastBatchInfo.appendIndex());
    }

    private ArrayList<LogChannel> collectChannels(long startingAppendIndex, LogPosition minimalLogPosition, long minimalVersion, long highestAppendIndex, LogPosition highestLogPosition) throws IOException {
        long highestLogVersion = highestLogPosition.getLogVersion();
        int exposedChannels = (int)(highestLogVersion - minimalVersion + 1L);
        ArrayList<LogChannel> channels = new ArrayList<LogChannel>(exposedChannels);
        MutableLongObjectMap internalChannels = LongObjectMaps.mutable.ofInitialCapacity(exposedChannels);
        for (long version = minimalVersion; version <= highestLogVersion; ++version) {
            LogHeader logHeader = this.logFile.extractHeader(version);
            long startPositionAppendIndex = this.logFileAppendIndex(startingAppendIndex, minimalVersion, version, logHeader);
            KernelVersion kernelVersion = this.getKernelVersion(startPositionAppendIndex, logHeader);
            ReadOnlyStoreChannel readOnlyStoreChannel = new ReadOnlyStoreChannel(this.logFile, version);
            if (version == minimalVersion) {
                Optional<Long> offset = TransactionLogServiceImpl.skipAnyZeroPadding(minimalLogPosition, logHeader, readOnlyStoreChannel);
                if (offset.isEmpty()) continue;
                readOnlyStoreChannel.position(offset.get());
            }
            internalChannels.put(version, (Object)readOnlyStoreChannel);
            long endOffset = version < highestLogVersion ? readOnlyStoreChannel.size() : highestLogPosition.getByteOffset();
            long lastAppendIndex = version < highestLogVersion ? this.logFile.extractHeader(version + 1L).getLastAppendIndex() : highestAppendIndex;
            channels.add(new LogChannel(startPositionAppendIndex, kernelVersion, (StoreChannel)readOnlyStoreChannel, readOnlyStoreChannel.position(), endOffset, lastAppendIndex, this.logFilePrevChecksum(startPositionAppendIndex, minimalVersion, version, logHeader), logHeader.getLogFormatVersion()));
        }
        this.logFile.registerExternalReaders((LongObjectMap<StoreChannel>)internalChannels);
        return channels;
    }

    private static Optional<Long> skipAnyZeroPadding(LogPosition minimalLogPosition, LogHeader logHeader, ReadOnlyStoreChannel readOnlyStoreChannel) throws IOException {
        long offset = minimalLogPosition.getByteOffset();
        int segmentSize = logHeader.getSegmentBlockSize();
        if (logHeader.getLogFormatVersion().usesSegments() && offset % (long)segmentSize >= (long)(segmentSize - 31) && (offset = (offset / (long)segmentSize + 1L) * (long)segmentSize) >= readOnlyStoreChannel.size()) {
            return Optional.empty();
        }
        return Optional.of(offset);
    }

    private long logFileAppendIndex(long startingAppendIndex, long minimalVersion, long version, LogHeader logHeader) {
        return version == minimalVersion ? startingAppendIndex : logHeader.getLastAppendIndex() + 1L;
    }

    private int logFilePrevChecksum(long startingAppendIndex, long minimalVersion, long version, LogHeader logHeader) throws IOException {
        return version != minimalVersion ? logHeader.getPreviousLogFileChecksum() : this.logFilePrevChecksumMiddleOfFile(logHeader, startingAppendIndex);
    }

    private int logFilePrevChecksumMiddleOfFile(LogHeader logHeader, long startingAppendIndex) throws IOException {
        int n;
        block9: {
            if (!logHeader.getLogFormatVersion().usesSegments()) {
                return 1;
            }
            CommandBatchCursor commandBatchCursor = this.transactionStore.getCommandBatches(startingAppendIndex);
            try {
                commandBatchCursor.next();
                n = ((CommittedCommandBatchRepresentation)commandBatchCursor.get()).previousChecksum();
                if (commandBatchCursor == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (commandBatchCursor != null) {
                        try {
                            commandBatchCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchLogEntryException e) {
                    throw new IllegalArgumentException("Append index " + startingAppendIndex + " not found in transaction logs.", e);
                }
            }
            commandBatchCursor.close();
        }
        return n;
    }

    private LogPosition getLogPosition(long appendIndex) throws IOException {
        LogPosition logPosition;
        block8: {
            CommandBatchCursor commandBatchCursor = this.transactionStore.getCommandBatches(appendIndex);
            try {
                logPosition = commandBatchCursor.position();
                if (commandBatchCursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (commandBatchCursor != null) {
                        try {
                            commandBatchCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchLogEntryException e) {
                    throw new IllegalArgumentException("Append index " + appendIndex + " not found in transaction logs.", e);
                }
            }
            commandBatchCursor.close();
        }
        return logPosition;
    }

    private AppendBatchInfo getAppendBatchInfo(long appendIndex) throws IOException {
        AppendBatchInfo appendBatchInfo;
        block8: {
            CommandBatchCursor commandBatchCursor = this.transactionStore.getCommandBatches(appendIndex);
            try {
                commandBatchCursor.next();
                appendBatchInfo = new AppendBatchInfo(appendIndex, commandBatchCursor.position());
                if (commandBatchCursor == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (commandBatchCursor != null) {
                        try {
                            commandBatchCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchLogEntryException e) {
                    throw new IllegalArgumentException("Append index " + appendIndex + " not found in transaction logs.", e);
                }
            }
            commandBatchCursor.close();
        }
        return appendBatchInfo;
    }

    private KernelVersion getKernelVersion(long appendIndex, LogHeader logHeader) throws IOException {
        KernelVersion kernelVersion;
        block10: {
            KernelVersion logHeaderKernelVersion = logHeader.getKernelVersion();
            if (logHeaderKernelVersion != null) {
                return logHeaderKernelVersion;
            }
            CommandBatchCursor commandBatchCursor = this.transactionStore.getCommandBatches(appendIndex);
            try {
                if (!commandBatchCursor.next()) {
                    throw new NoSuchLogEntryException(appendIndex);
                }
                kernelVersion = ((CommittedCommandBatchRepresentation)commandBatchCursor.get()).commandBatch().kernelVersion();
                if (commandBatchCursor == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (commandBatchCursor != null) {
                        try {
                            commandBatchCursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchLogEntryException e) {
                    throw new IllegalArgumentException("Couldn't get kernel version for append index " + appendIndex + " as it can't be found in transaction logs.", e);
                }
            }
            commandBatchCursor.close();
        }
        return kernelVersion;
    }

    private static class ReadOnlyStoreChannel
    extends DelegatingStoreChannel<StoreChannel> {
        private final LogFile logFile;
        private final long version;

        ReadOnlyStoreChannel(LogFile logFile, long version) throws IOException {
            super((StoreChannel)logFile.openForVersion(version));
            this.logFile = logFile;
            this.version = version;
        }

        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public int write(ByteBuffer src) {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public void writeAll(ByteBuffer src) {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public void writeAll(ByteBuffer src, long position) {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public StoreChannel truncate(long size) {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public long write(ByteBuffer[] srcs) {
            throw new UnsupportedOperationException("Read only channel does not support any write operations.");
        }

        public void close() throws IOException {
            this.logFile.unregisterExternalReader(this.version, (StoreChannel)this);
            super.close();
        }
    }
}

