/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.systemgraph;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphDbmsModelUtil;
import org.neo4j.dbms.systemgraph.DriverSettings;
import org.neo4j.dbms.systemgraph.ExternalDatabaseCredentials;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.kernel.database.DatabaseReference;
import org.neo4j.kernel.database.DatabaseReferenceImpl;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.database.NormalizedCatalogEntry;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class CommunityTopologyGraphDbmsModel
implements TopologyGraphDbmsModel {
    protected final Transaction tx;

    public CommunityTopologyGraphDbmsModel(Transaction tx) {
        this.tx = tx;
    }

    public Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> getAllDatabaseAccess() {
        try (ResourceIterator nodes = this.tx.findNodes(DATABASE_LABEL);){
            Map<NamedDatabaseId, TopologyGraphDbmsModel.DatabaseAccess> map = nodes.stream().collect(Collectors.toMap(CommunityTopologyGraphDbmsModelUtil::getDatabaseId, CommunityTopologyGraphDbmsModelUtil::getDatabaseAccess));
            return map;
        }
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByAlias(String databaseName) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdByAliasInRoot(this.tx, databaseName).or(() -> CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "name", databaseName));
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "uuid", uuid.toString());
    }

    @Override
    public Optional<NamedDatabaseId> getDatabaseIdByUUID(UUID uuid, boolean resolveToShardedDb) {
        return CommunityTopologyGraphDbmsModelUtil.getDatabaseIdBy(this.tx, "uuid", uuid.toString());
    }

    @Override
    public Set<DatabaseReference> getAllDatabaseReferences() {
        Stream<DatabaseReferenceImpl.Internal> primaryRefs = CommunityTopologyGraphDbmsModelUtil.getAllPrimaryStandardDatabaseReferencesInRoot(this.tx);
        Stream<DatabaseReferenceImpl.Internal> internalAliasRefs = this.getAllInternalDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.External> externalRefs = this.getAllExternalDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.Composite> compositeRefs = this.getAllCompositeDatabaseReferencesInRoot();
        Stream<DatabaseReferenceImpl.VirtualSPD> virtualSPDRefs = this.getAllVirtualSPDReferencesInRoot();
        Stream<DatabaseReferenceImpl.GraphShard> spdGraphShardRefs = this.getAllSPDGraphShardReferencesInRoot();
        Stream<DatabaseReferenceImpl.PropertyShard> spdPropertyShardRefs = this.getAllSPDPropertyShardReferencesInRoot();
        Stream<DatabaseReferenceImpl.Mirror> mirrorRefs = this.getAllMirrorReferencesInRoot();
        return Stream.of(primaryRefs, internalAliasRefs, externalRefs, compositeRefs, virtualSPDRefs, spdGraphShardRefs, spdPropertyShardRefs, mirrorRefs).flatMap(s -> s).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Set<DatabaseReferenceImpl.Composite> getAllCompositeDatabaseReferences() {
        return this.getAllCompositeDatabaseReferencesInRoot().collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByAlias(NormalizedCatalogEntry catalogEntry) {
        if (catalogEntry.compositeDb().isPresent()) {
            return this.resolveConstituent((String)catalogEntry.compositeDb().get(), catalogEntry.databaseAlias());
        }
        return this.resolveRootReference(catalogEntry.databaseAlias());
    }

    @Override
    public Optional<DatabaseReference> getDatabaseRefByDisplayName(NormalizedDatabaseName displayName) {
        return Optional.empty().or(() -> this.getCompositeDatabaseReference(displayName.name())).or(() -> this.getVirtualSPDReferences(displayName.name())).or(() -> this.getSPDGraphShardReference(displayName.name())).or(() -> this.getSPDPropertyShardReference(displayName.name())).or(() -> this.getMirrorReferences(displayName.name())).or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(this.tx, displayName.name())).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReference(this.tx, displayName.name()));
    }

    private Optional<DatabaseReference> resolveConstituent(String composite, String constituent) {
        return Optional.empty().or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReference(this.tx, composite, constituent)).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReferenceInRoot(this.tx, composite, constituent));
    }

    private Optional<DatabaseReference> resolveRootReference(String normalizedDatabaseAlias) {
        return Optional.empty().or(() -> this.getCompositeDatabaseReferenceInRoot(normalizedDatabaseAlias)).or(() -> this.getVirtualSPDReferencesInRoot(normalizedDatabaseAlias)).or(() -> this.getSPDGraphShardReferenceInRoot(normalizedDatabaseAlias)).or(() -> this.getSPDPropertyShardReferenceInRoot(normalizedDatabaseAlias)).or(() -> this.getMirrorReferencesInRoot(normalizedDatabaseAlias)).or(() -> CommunityTopologyGraphDbmsModelUtil.getInternalDatabaseReferenceInRoot(this.tx, normalizedDatabaseAlias)).or(() -> CommunityTopologyGraphDbmsModelUtil.getExternalDatabaseReferenceInRoot(this.tx, normalizedDatabaseAlias));
    }

    private Stream<Node> getAllAliasNodesInRoot() {
        return this.getAllAliasNodesInNamespace("system-root");
    }

    private Stream<Node> getAllAliasNodesInNamespace(String namespace) {
        return this.tx.findNodes(DATABASE_NAME_LABEL, "namespace", (Object)namespace).stream().toList().stream();
    }

    private Stream<Node> getRemoteAliasNodesInNamespace(String namespace) {
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "namespace", (Object)namespace).stream().toList().stream();
    }

    private Stream<Node> getAliasNodeInNamespace(String namespace, String databaseName) {
        return this.tx.findNodes(DATABASE_NAME_LABEL, "namespace", (Object)namespace, "name", (Object)databaseName).stream().toList().stream();
    }

    private Stream<Node> getAliasNode(String displayName) {
        return this.tx.findNodes(DATABASE_NAME_LABEL, "displayName", (Object)displayName).stream().toList().stream();
    }

    private Stream<Node> getAliasNodeInRoot(String databaseName) {
        return this.getAliasNodeInNamespace("system-root", databaseName);
    }

    @Override
    public Optional<DriverSettings> getDriverSettings(String databaseName, String namespace) {
        databaseName = NormalizedDatabaseName.normalize((String)databaseName);
        namespace = NormalizedDatabaseName.normalize((String)namespace);
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().toList().stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getDriverSettings);
    }

    @Override
    public Optional<Map<String, Object>> getAliasProperties(String databaseName, String namespace) {
        databaseName = NormalizedDatabaseName.normalize((String)databaseName);
        namespace = NormalizedDatabaseName.normalize((String)namespace);
        return this.getAliasNodeInNamespace(namespace, databaseName).findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getAliasProperties);
    }

    @Override
    public Optional<CypherVersion> getRemoteAliasLanguageVersion(String remoteAliasName) {
        try (ResourceIterator nodes = this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)remoteAliasName);){
            List<Node> filtered = nodes.stream().filter(node -> node.getProperty("namespace").equals("system-root")).toList();
            if (filtered.isEmpty()) {
                Optional<CypherVersion> optional = Optional.empty();
                return optional;
            }
            String defaultLanguage = (String)filtered.getFirst().getProperty("defaultLanguage");
            if (defaultLanguage != null) {
                Optional optional = CypherVersion.fromStoredValueOptional((Object)defaultLanguage);
                return optional;
            }
            Optional<CypherVersion> optional = Optional.empty();
            return optional;
        }
    }

    @Override
    public Optional<ExternalDatabaseCredentials> getExternalDatabaseCredentials(DatabaseReferenceImpl.External databaseReference) {
        String databaseName = databaseReference.alias().name();
        String namespace = databaseReference.namespace().map(NormalizedDatabaseName::name).orElse("system-root");
        return this.tx.findNodes(REMOTE_DATABASE_LABEL, "name", (Object)databaseName, "namespace", (Object)namespace).stream().toList().stream().findFirst().flatMap(CommunityTopologyGraphDbmsModelUtil::getDatabaseCredentials);
    }

    private Stream<DatabaseReferenceImpl.Mirror> getAllMirrorReferencesInRoot() {
        return this.getAllAliasNodesInRoot().flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(MIRROR_LABEL)).flatMap(db -> CommunityTopologyGraphDbmsModel.createMirrorReference(alias, db)).stream());
    }

    private Optional<DatabaseReferenceImpl.Mirror> getMirrorReferences(String displayName) {
        return this.getMirrorReferences(this.getAliasNode(displayName));
    }

    private Optional<DatabaseReferenceImpl.Mirror> getMirrorReferencesInRoot(String databaseName) {
        return this.getMirrorReferences(this.getAliasNodeInRoot(databaseName));
    }

    private Optional<DatabaseReferenceImpl.Mirror> getMirrorReferences(Stream<Node> aliases) {
        return aliases.flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(MIRROR_LABEL)).flatMap(db -> CommunityTopologyGraphDbmsModel.createMirrorReference(alias, db)).stream()).findFirst();
    }

    private Stream<DatabaseReferenceImpl.Composite> getAllCompositeDatabaseReferencesInRoot() {
        return this.getAllAliasNodesInRoot().flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReferenceImpl.Composite> getCompositeDatabaseReferenceInRoot(String databaseName) {
        return this.getCompositeDatabaseReference(this.getAliasNodeInRoot(databaseName));
    }

    private Optional<DatabaseReferenceImpl.Composite> getCompositeDatabaseReference(String displayName) {
        return this.getCompositeDatabaseReference(this.getAliasNode(displayName));
    }

    private Optional<DatabaseReferenceImpl.Composite> getCompositeDatabaseReference(Stream<Node> aliases) {
        return aliases.flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(COMPOSITE_DATABASE_LABEL)).flatMap(db -> this.createCompositeReference((Node)alias, (Node)db)).stream()).findFirst();
    }

    private Optional<DatabaseReferenceImpl.Composite> createCompositeReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE_NAME, alias);
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            NormalizedDatabaseName compositeName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE, db);
            Set<DatabaseReference> components = this.getAllDatabaseReferencesInComposite(compositeName);
            return Optional.of(new DatabaseReferenceImpl.Composite(aliasName, databaseId, components));
        });
    }

    private Stream<DatabaseReferenceImpl.VirtualSPD> getAllVirtualSPDReferencesInRoot() {
        return this.getAllAliasNodesInRoot().flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(SPD_LABEL)).flatMap(db -> this.createVirtualSPDReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReferenceImpl.VirtualSPD> getVirtualSPDReferences(String displayName) {
        return this.getVirtualSPDReferences(this.getAliasNode(displayName));
    }

    private Optional<DatabaseReferenceImpl.VirtualSPD> getVirtualSPDReferencesInRoot(String databaseName) {
        return this.getVirtualSPDReferences(this.getAliasNodeInRoot(databaseName));
    }

    private Optional<DatabaseReferenceImpl.VirtualSPD> getVirtualSPDReferences(Stream<Node> nodes) {
        return nodes.flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(SPD_LABEL)).flatMap(db -> this.createVirtualSPDReference((Node)alias, (Node)db)).stream()).findFirst();
    }

    private Stream<DatabaseReferenceImpl.GraphShard> getAllSPDGraphShardReferencesInRoot() {
        return this.getAllAliasNodesInRoot().flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(GRAPH_SHARD_LABEL)).flatMap(db -> this.createSPDGraphShardReference((Node)alias, (Node)db)).stream());
    }

    private Optional<DatabaseReferenceImpl.GraphShard> getSPDGraphShardReference(String displayName) {
        return this.getSPDGraphShardReferenceInRoot(this.getAliasNode(displayName));
    }

    private Optional<DatabaseReferenceImpl.GraphShard> getSPDGraphShardReferenceInRoot(String databaseName) {
        return this.getSPDGraphShardReferenceInRoot(this.getAliasNodeInRoot(databaseName));
    }

    private Optional<DatabaseReferenceImpl.GraphShard> getSPDGraphShardReferenceInRoot(Stream<Node> nodes) {
        return nodes.flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(GRAPH_SHARD_LABEL)).flatMap(db -> this.createSPDGraphShardReference((Node)alias, (Node)db)).stream()).findFirst();
    }

    private Stream<DatabaseReferenceImpl.PropertyShard> getAllSPDPropertyShardReferencesInRoot() {
        return this.getAllAliasNodesInRoot().flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(PROPERTY_SHARD_LABEL)).flatMap(db -> CommunityTopologyGraphDbmsModel.createSPDPropertyShardReference(alias, db)).stream());
    }

    private Optional<DatabaseReferenceImpl.PropertyShard> getSPDPropertyShardReference(String displayName) {
        return this.getSPDPropertyShardReference(this.getAliasNode(displayName));
    }

    private Optional<DatabaseReferenceImpl.PropertyShard> getSPDPropertyShardReferenceInRoot(String databaseName) {
        return this.getSPDPropertyShardReference(this.getAliasNodeInRoot(databaseName));
    }

    private Optional<DatabaseReferenceImpl.PropertyShard> getSPDPropertyShardReference(Stream<Node> nodes) {
        return nodes.flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(db -> db.hasLabel(PROPERTY_SHARD_LABEL)).flatMap(db -> CommunityTopologyGraphDbmsModel.createSPDPropertyShardReference(alias, db)).stream()).findFirst();
    }

    private Optional<DatabaseReferenceImpl.VirtualSPD> createVirtualSPDReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName spdAliasName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE_NAME, alias);
            NamedDatabaseId spdNamedDatabaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            List graphShard = db.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_GRAPH_SHARD_RELATIONSHIP}).stream().flatMap(rel -> this.createSPDGraphShardReference(rel.getEndNode()).stream()).toList();
            if (graphShard.isEmpty()) {
                return Optional.empty();
            }
            boolean isPrimary = (Boolean)alias.getProperty("primary");
            return Optional.of(new DatabaseReferenceImpl.VirtualSPD(spdAliasName, new NormalizedDatabaseName((String)alias.getProperty("namespace")), spdNamedDatabaseId, (DatabaseReference)graphShard.getFirst(), isPrimary));
        });
    }

    private Optional<DatabaseReferenceImpl.GraphShard> createSPDGraphShardReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NormalizedDatabaseName aliasName = CommunityTopologyGraphDbmsModelUtil.getNameProperty(DATABASE_NAME, alias);
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            Map<Integer, DatabaseReferenceImpl.PropertyShard> shards = StreamSupport.stream(db.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_PROPERTY_SHARD_RELATIONSHIP}).spliterator(), false).flatMap(rel -> this.getDatabaseRefByAlias(new NormalizedCatalogEntry((String)rel.getEndNode().getProperty("name"))).map(ref -> Pair.of((Object)((Integer)rel.getProperty("index")), (Object)((DatabaseReferenceImpl.PropertyShard)ref))).stream()).collect(Collectors.toMap(Pair::first, Pair::other));
            String owningDatabase = CommunityTopologyGraphDbmsModelUtil.readGraphShardOwningDatabase(db).orElseThrow();
            return Optional.of(new DatabaseReferenceImpl.GraphShard(aliasName, databaseId, owningDatabase, shards));
        });
    }

    private Optional<DatabaseReferenceImpl.GraphShard> createSPDGraphShardReference(Node db) {
        NormalizedDatabaseName aliasName = new NormalizedDatabaseName((String)db.getProperty("name"));
        return CommunityTopologyGraphDbmsModelUtil.ignoreConcurrentDeletes(() -> {
            NamedDatabaseId databaseId = CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db);
            Map<Integer, DatabaseReferenceImpl.PropertyShard> shards = StreamSupport.stream(db.getRelationships(Direction.OUTGOING, new RelationshipType[]{TopologyGraphDbmsModel.HAS_PROPERTY_SHARD_RELATIONSHIP}).spliterator(), false).flatMap(rel -> this.getDatabaseRefByAlias(new NormalizedCatalogEntry((String)rel.getEndNode().getProperty("name"))).map(ref -> Pair.of((Object)((Integer)rel.getProperty("index")), (Object)((DatabaseReferenceImpl.PropertyShard)ref))).stream()).collect(Collectors.toMap(Pair::first, Pair::other));
            String owningDatabase = CommunityTopologyGraphDbmsModelUtil.readGraphShardOwningDatabase(db).orElseThrow();
            return Optional.of(new DatabaseReferenceImpl.GraphShard(aliasName, databaseId, owningDatabase, shards));
        });
    }

    private static Optional<DatabaseReferenceImpl.PropertyShard> createSPDPropertyShardReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db)).flatMap(internal -> CommunityTopologyGraphDbmsModelUtil.readPropertyShardOwningDatabaseAndIndex(db).map(p -> internal.asShard((String)p.first(), (Integer)p.other())));
    }

    private static Optional<DatabaseReferenceImpl.Mirror> createMirrorReference(Node alias, Node db) {
        return CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, CommunityTopologyGraphDbmsModelUtil.getDatabaseId(db)).map(DatabaseReferenceImpl.Internal::asMirror);
    }

    private Set<DatabaseReference> getAllDatabaseReferencesInComposite(NormalizedDatabaseName compositeName) {
        Stream<DatabaseReferenceImpl.Internal> internalRefs = this.getAllInternalDatabaseReferencesInNamespace(compositeName.name());
        Stream<DatabaseReferenceImpl.Internal> spdInternalRefs = this.getAllSpdDatabaseReferencesInNamespace(compositeName.name());
        Stream<DatabaseReferenceImpl.External> externalRefs = this.getAllExternalDatabaseReferencesInNamespace(compositeName.name());
        return Stream.concat(Stream.concat(internalRefs, externalRefs), spdInternalRefs).collect(Collectors.toUnmodifiableSet());
    }

    private Stream<DatabaseReferenceImpl.External> getAllExternalDatabaseReferencesInRoot() {
        return this.getAllExternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReferenceImpl.External> getAllExternalDatabaseReferencesInNamespace(String namespace) {
        return this.getRemoteAliasNodesInNamespace(namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.createExternalReference(alias).stream());
    }

    private Stream<DatabaseReferenceImpl.Internal> getAllInternalDatabaseReferencesInRoot() {
        return this.getAllInternalDatabaseReferencesInNamespace("system-root");
    }

    private Stream<DatabaseReferenceImpl.Internal> getAllInternalDatabaseReferencesInNamespace(String namespace) {
        return this.getAllAliasNodesInNamespace(namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(node -> !node.hasLabel(COMPOSITE_DATABASE_LABEL)).filter(node -> !node.hasLabel(SPD_LABEL)).filter(node -> !node.hasLabel(GRAPH_SHARD_LABEL)).filter(node -> !node.hasLabel(PROPERTY_SHARD_LABEL)).filter(node -> !node.hasLabel(MIRROR_LABEL)).map(CommunityTopologyGraphDbmsModelUtil::getDatabaseId).flatMap(db -> CommunityTopologyGraphDbmsModelUtil.createInternalReference(alias, db)).stream());
    }

    private Stream<DatabaseReferenceImpl.Internal> getAllSpdDatabaseReferencesInNamespace(String namespace) {
        return this.getAllAliasNodesInNamespace(namespace).flatMap(alias -> CommunityTopologyGraphDbmsModelUtil.getTargetedDatabaseNode(alias).filter(node -> !node.hasLabel(COMPOSITE_DATABASE_LABEL)).filter(node -> node.hasLabel(SPD_LABEL)).flatMap(db -> this.createVirtualSPDReference((Node)alias, (Node)db)).stream());
    }
}

