/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import java.util.Optional;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.NoSuchLogEntryException;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;

public class AppendedChunkLogVersionLocator
implements LogHeaderVisitor {
    private final long appendIndex;
    private LogPosition foundPosition;

    public AppendedChunkLogVersionLocator(long appendIndex) {
        this.appendIndex = appendIndex;
    }

    @Override
    public boolean visit(LogHeader logHeader, LogPosition position, long lowApplyIndex, long lastApplyIndex) {
        boolean foundIt;
        boolean bl = foundIt = this.appendIndex >= lowApplyIndex && this.appendIndex <= lastApplyIndex;
        if (foundIt) {
            this.foundPosition = position;
        }
        return !foundIt;
    }

    public LogPosition getLogPositionOrThrow() throws NoSuchLogEntryException {
        if (this.foundPosition == null) {
            throw new NoSuchLogEntryException(this.appendIndex);
        }
        return this.foundPosition;
    }

    public Optional<LogPosition> getOptionalLogPosition() {
        return Optional.ofNullable(this.foundPosition);
    }
}

