/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.Cursor;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.PartitionedScan;
import org.neo4j.internal.kernel.api.PropertyIndexQuery;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.api.ExecutionContext;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.index.schema.PartitionedValueSeek;
import org.neo4j.kernel.impl.newapi.DefaultEntityValueIndexCursor;

public class PartitionedValueIndexCursorSeek<Cursor extends Cursor>
implements PartitionedScan<Cursor> {
    private final PartitionedValueSeek valueSeek;
    private final PropertyIndexQuery[] query;
    private final IndexDescriptor descriptor;

    public PartitionedValueIndexCursorSeek(IndexDescriptor descriptor, PartitionedValueSeek valueSeek, PropertyIndexQuery ... query) {
        this.descriptor = descriptor;
        this.valueSeek = valueSeek;
        this.query = query;
    }

    public int getNumberOfPartitions() {
        return this.valueSeek.getNumberOfPartitions();
    }

    public boolean reservePartition(Cursor cursor, ExecutionContext executionContext) {
        DefaultEntityValueIndexCursor indexCursor = (DefaultEntityValueIndexCursor)cursor;
        indexCursor.initState(executionContext.dataRead(), executionContext.txStateHolder(), executionContext.accessModeProvider());
        IndexProgressor indexProgressor = this.valueSeek.reservePartition((IndexProgressor.EntityValueClient)indexCursor, executionContext.cursorContext());
        if (indexProgressor == IndexProgressor.EMPTY) {
            return false;
        }
        indexCursor.initializeQuery(this.descriptor, indexProgressor, false, false, IndexQueryConstraints.unorderedValues(), this.query);
        return true;
    }
}

