/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.LoggingMonitor;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.token.TokenHolders;

public abstract class AbstractIndexProviderFactory<T extends IndexProvider> {
    public T create(PageCache pageCache, FileSystemAbstraction fs, LogService logService, Monitors monitors, Config config, DatabaseReadOnlyChecker readOnlyChecker, TopologyGraphDbmsModel.HostedOnMode mode, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, DatabaseLayout databaseLayout, TokenHolders tokenHolders, JobScheduler scheduler, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, DependencyResolver dependencyResolver) {
        if (TopologyGraphDbmsModel.HostedOnMode.SINGLE != mode) {
            readOnlyChecker = DatabaseReadOnlyChecker.writable();
        }
        InternalLog log = logService.getInternalLogProvider().getLog(this.loggingClass());
        String monitorTag = this.descriptor().toString();
        monitors.addMonitorListener((Object)new LoggingMonitor(log), new String[]{monitorTag});
        return this.internalCreate(pageCache, fs, monitors, monitorTag, config, readOnlyChecker, recoveryCleanupWorkCollector, databaseLayout, logService.getInternalLogProvider(), tokenHolders, scheduler, contextFactory, pageCacheTracer, dependencyResolver);
    }

    protected abstract Class<?> loggingClass();

    public abstract IndexProviderDescriptor descriptor();

    protected abstract T internalCreate(PageCache var1, FileSystemAbstraction var2, Monitors var3, String var4, Config var5, DatabaseReadOnlyChecker var6, RecoveryCleanupWorkCollector var7, DatabaseLayout var8, InternalLogProvider var9, TokenHolders var10, JobScheduler var11, CursorContextFactory var12, PageCacheTracer var13, DependencyResolver var14);
}

