/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.device;

import org.neo4j.annotations.service.Service;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.service.PrioritizedService;
import org.neo4j.service.Services;

@Service
public interface DeviceMapperService
extends PrioritizedService {
    public DeviceMapper createDeviceMapper(InternalLogProvider var1, FileSystemAbstraction var2);

    public static DeviceMapperService getInstance() {
        return DeviceMapperProviderHolder.DEVICE_MAPPER_SERVICE_PROVIDER;
    }

    public static final class DeviceMapperProviderHolder {
        private static final DeviceMapperService DEVICE_MAPPER_SERVICE_PROVIDER = DeviceMapperProviderHolder.loadDeviceMapper();

        private DeviceMapperProviderHolder() {
        }

        private static DeviceMapperService loadDeviceMapper() {
            return (DeviceMapperService)Services.loadByPriority(DeviceMapperService.class).orElseThrow(() -> new IllegalStateException("Failed to load instance of " + String.valueOf(DeviceMapperService.class)));
        }
    }
}

