/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.function.LongConsumer;
import org.neo4j.common.Subject;
import org.neo4j.internal.helpers.Format;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class CompleteTransaction
implements StorageEngineTransaction {
    private final CommandBatch commandBatch;
    private boolean idGenerated;
    private long transactionId;
    private final CursorContext cursorContext;
    private final StoreCursors storeCursors;
    private final TransactionIdGenerator transactionIdGenerator;
    private StorageEngineTransaction next;
    private final Commitment commitment;
    private LongConsumer closedCallback;

    public CompleteTransaction(CommittedCommandBatchRepresentation committedCommandBatchRepresentation, CursorContext cursorContext, StoreCursors storeCursors) {
        this(committedCommandBatchRepresentation, cursorContext, storeCursors, Commitment.NO_COMMITMENT, TransactionIdGenerator.EXTERNAL_ID);
    }

    public CompleteTransaction(CommittedCommandBatchRepresentation committedCommandBatchRepresentation, CursorContext cursorContext, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this(committedCommandBatchRepresentation.commandBatch(), cursorContext, storeCursors, commitment, transactionIdGenerator);
        this.transactionId = committedCommandBatchRepresentation.txId();
    }

    public CompleteTransaction(CommandBatch commandBatch, CursorContext cursorContext, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this.commandBatch = commandBatch;
        this.cursorContext = cursorContext;
        this.storeCursors = storeCursors;
        this.commitment = commitment;
        this.transactionIdGenerator = transactionIdGenerator;
    }

    public void next(StorageEngineTransaction next) {
        this.next = next;
    }

    public void commit() {
        this.commitment.publishAsCommitedLastBatch();
        this.commitment.publishAsCommitted(this.commandBatch.getTimeCommitted(), this.commandBatch.appendIndex());
    }

    public long transactionId() {
        if (this.idGenerated) {
            return this.transactionId;
        }
        this.transactionId = this.transactionIdGenerator.nextId(this.transactionId);
        this.idGenerated = true;
        return this.transactionId;
    }

    public long chunkId() {
        return 0L;
    }

    public long previousBatchAppendIndex() {
        return 0L;
    }

    public Subject subject() {
        return this.commandBatch.subject();
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public StoreCursors storeCursors() {
        return this.storeCursors;
    }

    public CommandBatch commandBatch() {
        return this.commandBatch;
    }

    public void batchAppended(long appendIndex, LogPosition beforeCommit, LogPosition positionAfter, int checksum) {
        this.commitment.commit(this.transactionId, appendIndex, true, true, this.commandBatch.kernelVersion(), beforeCommit, positionAfter, checksum, this.commandBatch.consensusIndex());
        VersionContext versionContext = this.cursorContext.getVersionContext();
        versionContext.initWrite(this.transactionId);
        versionContext.initAppendIndex(appendIndex);
        this.commandBatch.setAppendIndex(appendIndex);
    }

    public void updateClusteredInfo(long transactionId, long appendIndex) {
    }

    public StorageEngineTransaction next() {
        return this.next;
    }

    public void onClose(LongConsumer closedCallback) {
        this.closedCallback = closedCallback;
    }

    public void close() {
        this.commitment.publishAsClosed();
        if (this.closedCallback != null) {
            this.closedCallback.accept(this.transactionId);
        }
    }

    public String toString() {
        CommandBatch tr = this.commandBatch;
        return "Transaction #" + this.transactionId + " {started " + Format.date((long)tr.getTimeStarted()) + ", committed " + Format.date((long)tr.getTimeCommitted()) + ", with " + this.commandBatch.commandCount() + " commands in this transaction, lease " + tr.getLeaseId() + ", latest committed transaction id when started was " + tr.getLatestCommittedTxWhenStarted() + ", consensusIndex: " + tr.consensusIndex() + "}";
    }
}

