/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.NodeLabelExistenceConstraintDescriptor;
import org.neo4j.token.api.TokenType;

public final class NodeLabelExistenceMissingLabelException
extends ConstraintValidationException {
    private final NodeLabelExistenceConstraintDescriptor descriptor;
    private final long nodeReference;

    private NodeLabelExistenceMissingLabelException(ErrorGqlStatusObject gqlStatusObject, NodeLabelExistenceConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long nodeReference, TokenNameLookup tokenNameLookup) {
        super(gqlStatusObject, (ConstraintDescriptor)descriptor, phase, String.format("Node(%d)", nodeReference), tokenNameLookup);
        this.descriptor = descriptor;
        this.nodeReference = nodeReference;
    }

    public static NodeLabelExistenceMissingLabelException tokenPresenceVerificationFailed(NodeLabelExistenceConstraintDescriptor descriptor, ConstraintValidationException.Phase phase, long nodeReference, TokenNameLookup tokenNameLookup) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22NB3).withParam(GqlParams.StringParam.entityType, EntityType.NODE.name()).withParam(GqlParams.NumberParam.entityId, (Number)nodeReference).withParam(GqlParams.StringParam.tokenType1, TokenType.LABEL.getName()).withParam(GqlParams.StringParam.token1, tokenNameLookup.labelGetName(descriptor.schemaLabelId())).withParam(GqlParams.StringParam.tokenType2, TokenType.LABEL.getName()).withParam(GqlParams.StringParam.token2, tokenNameLookup.labelGetName(descriptor.requiredLabelId())).build();
        return new NodeLabelExistenceMissingLabelException(gql, descriptor, phase, nodeReference, tokenNameLookup);
    }

    public String getUserMessage(TokenNameLookup tokenNameLookup) {
        return String.format("Node(%d) with label %s is required to have label %s", this.nodeReference, tokenNameLookup.labelGetName(this.descriptor.schema().getLabelId()), tokenNameLookup.labelGetName(this.descriptor.requiredLabelId()));
    }
}

