/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.exceptions.KernelException;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.kernel.api.exceptions.Status;

public class IndexBrokenKernelException
extends KernelException {
    private IndexBrokenKernelException(ErrorGqlStatusObject gqlStatusObject, String indexFailureCause) {
        super(gqlStatusObject, (Status)Status.General.IndexCorruptionDetected, "The index is in a failed state: '%s'.", new Object[]{indexFailureCause});
    }

    public static IndexBrokenKernelException indexBroken(String indexName, String indexFailureCause) {
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_51N62).withParam(GqlParams.StringParam.idx, indexName).build();
        return new IndexBrokenKernelException(gql, indexFailureCause);
    }
}

