/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.logging.internal;

import java.util.Objects;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.Neo4jLogMessage;
import org.neo4j.logging.Neo4jMessageSupplier;
import org.neo4j.logging.internal.DatabaseLogIdentifier;
import org.neo4j.logging.internal.DatabaseTagLogMessage;

public class DatabaseLog
implements InternalLog {
    private final DatabaseLogIdentifier databaseLogIdentifier;
    private final InternalLog delegate;

    DatabaseLog(DatabaseLogIdentifier databaseLogIdentifier, InternalLog delegate) {
        Objects.requireNonNull(delegate, "delegate log cannot be null");
        this.databaseLogIdentifier = databaseLogIdentifier;
        this.delegate = delegate;
    }

    public void debug(Neo4jLogMessage message) {
        throw new UnsupportedOperationException("");
    }

    public void debug(Neo4jMessageSupplier supplier) {
        throw new UnsupportedOperationException("");
    }

    public void info(Neo4jLogMessage message) {
        throw new UnsupportedOperationException("");
    }

    public void info(Neo4jMessageSupplier supplier) {
        throw new UnsupportedOperationException("");
    }

    public void warn(Neo4jLogMessage message) {
        throw new UnsupportedOperationException("");
    }

    public void warn(Neo4jMessageSupplier supplier) {
    }

    public void error(Neo4jLogMessage message) {
    }

    public void error(Neo4jMessageSupplier supplier) {
    }

    public void error(Neo4jLogMessage message, Throwable throwable) {
    }

    public boolean isDebugEnabled() {
        return this.delegate.isDebugEnabled();
    }

    public void debug(String message) {
        this.delegate.debug((Neo4jLogMessage)this.taggedMessage(message));
    }

    public void debug(String message, Throwable throwable) {
        this.delegate.debug((Neo4jLogMessage)this.taggedMessage(message, throwable));
    }

    public void debug(String format, Object ... arguments) {
        this.delegate.debug((Neo4jLogMessage)this.taggedMessage(format, arguments));
    }

    public void info(String message) {
        this.delegate.info((Neo4jLogMessage)this.taggedMessage(message));
    }

    public void info(String message, Throwable throwable) {
        this.delegate.info((Neo4jLogMessage)this.taggedMessage(message, throwable));
    }

    public void info(String format, Object ... arguments) {
        this.delegate.info((Neo4jLogMessage)this.taggedMessage(format, arguments));
    }

    public void warn(String message) {
        this.delegate.warn((Neo4jLogMessage)this.taggedMessage(message));
    }

    public void warn(String message, Throwable throwable) {
        this.delegate.warn((Neo4jLogMessage)this.taggedMessage(message, throwable));
    }

    public void warn(String format, Object ... arguments) {
        this.delegate.warn((Neo4jLogMessage)this.taggedMessage(format, arguments));
    }

    public void error(String message) {
        this.delegate.error((Neo4jLogMessage)this.taggedMessage(message));
    }

    public void error(String message, Throwable throwable) {
        this.delegate.error((Neo4jLogMessage)this.taggedMessage(message, throwable));
    }

    public void error(String format, Object ... arguments) {
        this.delegate.error((Neo4jLogMessage)this.taggedMessage(format, arguments));
    }

    private DatabaseTagLogMessage taggedMessage(String message) {
        return new DatabaseTagLogMessage(this.databaseLogIdentifier, message, null);
    }

    private DatabaseTagLogMessage taggedMessage(String message, Throwable throwable) {
        return new DatabaseTagLogMessage(this.databaseLogIdentifier, message, throwable);
    }

    private DatabaseTagLogMessage taggedMessage(String message, Object ... arguments) {
        return new DatabaseTagLogMessage(this.databaseLogIdentifier, String.format(message, arguments), null);
    }
}

