/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Objects;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.kernel.impl.coreapi.schema.BaseConstraintDefinition;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.util.Preconditions;

final class RelationshipEndpointLabelConstraintDefinition
extends BaseConstraintDefinition {
    final RelationshipType constrainedRelationshipType;
    final Label requiredLabel;
    final EndpointType endpointType;

    RelationshipEndpointLabelConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, RelationshipType constrainedRelationshipType, Label requiredLabel, EndpointType endpointType) {
        super(actions, constraint);
        this.constrainedRelationshipType = constrainedRelationshipType;
        this.requiredLabel = requiredLabel;
        this.endpointType = endpointType;
        Preconditions.checkState((boolean)constraint.isRelationshipEndpointLabelConstraint(), (String)"constraint expected to be RelationshipEndpointLabelConstraint");
    }

    @Override
    public RelationshipType getRelationshipType() {
        this.assertInUnterminatedTransaction();
        return this.constrainedRelationshipType;
    }

    public ConstraintType getConstraintType() {
        return switch (this.endpointType) {
            default -> throw new MatchException(null, null);
            case EndpointType.START -> ConstraintType.RELATIONSHIP_SOURCE_LABEL;
            case EndpointType.END -> ConstraintType.RELATIONSHIP_TARGET_LABEL;
        };
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof RelationshipEndpointLabelConstraintDefinition) {
            RelationshipEndpointLabelConstraintDefinition that = (RelationshipEndpointLabelConstraintDefinition)o;
            return this.constrainedRelationshipType.name().equals(that.constrainedRelationshipType.name()) && this.requiredLabel.name().equals(that.requiredLabel.name()) && this.endpointType == that.endpointType;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.constrainedRelationshipType.name(), this.requiredLabel.name(), this.endpointType);
    }

    @Override
    public String toString() {
        String constrainedRelationshipTypeName = NameUtil.escapeName((String)this.constrainedRelationshipType.name());
        String requiredLabelName = NameUtil.escapeName((String)this.requiredLabel.name());
        return switch (this.endpointType) {
            default -> throw new MatchException(null, null);
            case EndpointType.START -> String.format("(:%s)-[:%s => ]->()", requiredLabelName, constrainedRelationshipTypeName);
            case EndpointType.END -> String.format("()-[:%s => ]->(:%s)", constrainedRelationshipTypeName, requiredLabelName);
        };
    }
}

