/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.neo4j.common.EntityType;
import org.neo4j.common.Subject;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptorSupplier;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.api.exceptions.index.ExceptionDuringFlipKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexProxyAlreadyClosedKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.TransactionVisibilityProvider;
import org.neo4j.kernel.impl.api.index.FailedIndexProxy;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexPopulationFailure;
import org.neo4j.kernel.impl.api.index.IndexPopulationJob;
import org.neo4j.kernel.impl.api.index.IndexProxyStrategy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.LoggingPhaseTracker;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.api.index.PropertyScanConsumer;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.api.index.TokenScanConsumer;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.Group;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.scheduler.JobMonitoringParams;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.EntityUpdates;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.Value;

public class MultipleIndexPopulator
implements StoreScan.ExternalUpdatesCheck,
AutoCloseable {
    private static final String MULTIPLE_INDEX_POPULATOR_TAG = "multipleIndexPopulator";
    private static final String EXTERNAL_UPDATES_QUEUE_TAG = "multipleIndexPopulator.externalUpdatesQueue";
    private static final String POPULATION_WORK_FLUSH_TAG = "populationWorkFlush";
    private static final String EOL = System.lineSeparator();
    private static final long VERSIONED_ENTRY_UPDATE_SIZE = HeapEstimator.shallowSizeOfInstance(VersionedEntryUpdate.class);
    private final int queueThreshold;
    final int batchMaxByteSizeScan;
    private final Queue<VersionedEntryUpdate> concurrentUpdateQueue = new LinkedBlockingQueue<VersionedEntryUpdate>();
    private final AtomicLong concurrentUpdateQueueByteSize = new AtomicLong();
    private final ConcurrentHashMap<IndexDescriptor, IndexPopulation> populations = new ConcurrentHashMap();
    private final AtomicLong activeTasks = new AtomicLong();
    private final IndexStoreView storeView;
    private final CursorContextFactory contextFactory;
    private final InternalLogProvider logProvider;
    private final InternalLog log;
    private final EntityType type;
    private final SchemaState schemaState;
    private final PhaseTracker phaseTracker;
    private final JobScheduler jobScheduler;
    private final CursorContext cursorContext;
    private final MemoryTracker memoryTracker;
    private final long horizonPollIntervalNanos;
    private volatile StoreScan storeScan;
    private final TokenNameLookup tokenNameLookup;
    private final String databaseName;
    private final Subject subject;
    private final TransactionVisibilityProvider transactionVisibilityProvider;
    private final IndexMonitor monitor;
    private final AtomicBoolean populationJobStopped = new AtomicBoolean(false);
    private final long transactionIdCreatedIndexes;
    private volatile long populationHorizon;

    public MultipleIndexPopulator(IndexStoreView storeView, InternalLogProvider logProvider, EntityType type, SchemaState schemaState, JobScheduler jobScheduler, TokenNameLookup tokenNameLookup, CursorContextFactory contextFactory, MemoryTracker memoryTracker, String databaseName, Subject subject, Config config, TransactionVisibilityProvider transactionVisibilityProvider, IndexMonitor monitor, CursorContext cursorContextOfIndexCreator) {
        this.storeView = storeView;
        this.contextFactory = contextFactory;
        this.cursorContext = contextFactory.create(MULTIPLE_INDEX_POPULATOR_TAG);
        this.memoryTracker = memoryTracker;
        this.logProvider = logProvider;
        this.log = logProvider.getLog(IndexPopulationJob.class);
        this.type = type;
        this.schemaState = schemaState;
        this.phaseTracker = new LoggingPhaseTracker(logProvider.getLog(IndexPopulationJob.class));
        this.jobScheduler = jobScheduler;
        this.tokenNameLookup = tokenNameLookup;
        this.databaseName = databaseName;
        this.subject = subject;
        this.queueThreshold = (Integer)config.get(GraphDatabaseInternalSettings.index_population_queue_threshold);
        this.batchMaxByteSizeScan = ((Long)config.get(GraphDatabaseInternalSettings.index_population_batch_max_byte_size)).intValue();
        this.horizonPollIntervalNanos = ((Duration)config.get(GraphDatabaseSettings.transaction_monitor_check_interval)).toNanos();
        this.transactionVisibilityProvider = transactionVisibilityProvider;
        this.monitor = monitor;
        this.populationHorizon = this.transactionIdCreatedIndexes = cursorContextOfIndexCreator.getVersionContext().committingTransactionId();
    }

    IndexPopulation addPopulator(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper) {
        IndexPopulation population = this.createPopulation(populator, indexProxyStrategy, flipper);
        this.populations.put(indexProxyStrategy.getIndexDescriptor(), population);
        return population;
    }

    private IndexPopulation createPopulation(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper) {
        return new IndexPopulation(populator, indexProxyStrategy, flipper);
    }

    boolean hasPopulators() {
        return !this.populations.isEmpty();
    }

    public void create(CursorContext cursorContext) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> {
            this.log.info("Index population started: [%s]", new Object[]{population.userDescription(this.tokenNameLookup)});
            population.create(cursorContext);
        }), cursorContext);
    }

    StoreScan createStoreScan(CursorContextFactory contextFactory) {
        int[] entityTokenIds = this.entityTokenIds();
        int[] propertyKeyIds = this.propertyKeyIds();
        PropertySelection propertySelection = PropertySelection.selection((int[])propertyKeyIds);
        if (this.type == EntityType.RELATIONSHIP) {
            StoreScan innerStoreScan = this.storeView.visitRelationships(entityTokenIds, propertySelection, this.createPropertyScanConsumer(), this.createTokenScanConsumer(), false, true, contextFactory, this.memoryTracker);
            this.storeScan = new LoggingStoreScan(innerStoreScan, false);
        } else {
            StoreScan innerStoreScan = this.storeView.visitNodes(entityTokenIds, propertySelection, this.createPropertyScanConsumer(), this.createTokenScanConsumer(), false, true, contextFactory, this.memoryTracker);
            this.storeScan = new LoggingStoreScan(innerStoreScan, true);
        }
        this.storeScan.setPhaseTracker(this.phaseTracker);
        return this.storeScan;
    }

    void queueConcurrentUpdate(IndexEntryUpdate update, CursorContext cursorContext) {
        VersionedEntryUpdate entryUpdate = new VersionedEntryUpdate(update, cursorContext.getVersionContext().committingTransactionId());
        this.concurrentUpdateQueue.add(entryUpdate);
        this.concurrentUpdateQueueByteSize.addAndGet(entryUpdate.heapSize());
    }

    public void cancel(Throwable failure, CursorContext cursorContext) {
        for (IndexPopulation population : this.populations.values()) {
            this.cancel(population, failure, cursorContext);
        }
    }

    protected void cancel(IndexPopulation population, Throwable failure, CursorContext cursorContext) {
        Throwable cause;
        if (!this.removeFromOngoingPopulations(population)) {
            return;
        }
        if (failure instanceof IndexPopulationFailedKernelException && (cause = failure.getCause()) instanceof IndexEntryConflictException) {
            failure = cause;
        }
        this.log.error(String.format("Failed to populate index: [%s]", population.userDescription(this.tokenNameLookup)), failure);
        IndexPopulationFailure indexPopulationFailure = IndexPopulationFailure.failure(failure);
        population.cancel(indexPopulationFailure);
        try {
            population.populator.markAsFailed(indexPopulationFailure.asString());
            population.populator.close(false, cursorContext);
        }
        catch (Throwable e) {
            this.log.error(String.format("Unable to close failed populator for index: [%s]", population.userDescription(this.tokenNameLookup)), e);
        }
    }

    @VisibleForTesting
    MultipleIndexUpdater newPopulatingUpdater(CursorContext cursorContext, CursorContext populatorContext) {
        MutableLongObjectMap updaters = LongObjectMaps.mutable.withInitialCapacity(this.populations.size());
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> updaters.put(population.indexProxyStrategy.getIndexDescriptor().getId(), (Object)new IndexPopulationUpdater((IndexPopulation)population, population.populator.newPopulatingUpdater(populatorContext)))), cursorContext);
        return new MultipleIndexUpdater(this, (MutableLongObjectMap<IndexPopulationUpdater>)updaters, this.logProvider, cursorContext);
    }

    @Override
    public void close() {
        this.phaseTracker.stop();
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.storeScan, this.cursorContext});
    }

    void resetIndexCounts(CursorContext cursorContext) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)this::resetIndexCountsForPopulation), cursorContext);
    }

    private void resetIndexCountsForPopulation(IndexPopulation indexPopulation) {
        indexPopulation.indexProxyStrategy.replaceStatisticsForIndex(new IndexSample(0L, 0L, 0L));
    }

    void flipAfterStoreScan(CursorContext cursorContext, boolean awaitHorizon) {
        for (IndexPopulation population : this.populations.values()) {
            try {
                population.scanCompleted(cursorContext);
                population.flip(cursorContext, awaitHorizon);
            }
            catch (Throwable t) {
                this.cancel(population, t, cursorContext);
            }
        }
    }

    private int[] propertyKeyIds() {
        return this.populations.values().stream().flatMapToInt(this::propertyKeyIds).distinct().toArray();
    }

    private IntStream propertyKeyIds(IndexPopulation population) {
        return IntStream.of(population.schema().getPropertyIds());
    }

    private int[] entityTokenIds() {
        return this.populations.values().stream().flatMapToInt(population -> Arrays.stream(population.schema().getEntityTokenIds())).sorted().distinct().toArray();
    }

    public void stop(CursorContext cursorContext) {
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> this.stop((IndexPopulation)population, cursorContext)), cursorContext);
    }

    void stop(IndexPopulation indexPopulation, CursorContext cursorContext) {
        indexPopulation.disconnectAndStop(cursorContext);
        this.checkEmpty();
    }

    private void checkEmpty() {
        StoreScan scan = this.storeScan;
        if (this.populations.isEmpty() && scan != null) {
            scan.stop();
        }
    }

    void dropIndexPopulation(IndexPopulation indexPopulation) {
        indexPopulation.disconnectAndDrop();
        this.checkEmpty();
    }

    private boolean removeFromOngoingPopulations(IndexPopulation indexPopulation) {
        return this.populations.remove(indexPopulation.indexProxyStrategy.getIndexDescriptor()) != null;
    }

    @Override
    public boolean needToApplyExternalUpdates() {
        int queueSize = this.concurrentUpdateQueue.size();
        return queueSize > 0 && queueSize >= this.queueThreshold || this.concurrentUpdateQueueByteSize.get() >= (long)this.batchMaxByteSizeScan;
    }

    @Override
    public void applyExternalUpdates(long currentlyIndexedEntityId) {
        if (this.concurrentUpdateQueue.isEmpty()) {
            return;
        }
        try (CursorContext populatorContext = this.cursorContext.createUnboundedReadRelatedContext(EXTERNAL_UPDATES_QUEUE_TAG);
             MultipleIndexUpdater updater = this.newPopulatingUpdater(this.cursorContext, populatorContext);){
            long updateByteSizeDrained = 0L;
            do {
                VersionedEntryUpdate update;
                if ((update = this.concurrentUpdateQueue.poll()) == null) continue;
                IndexEntryUpdate entryUpdate = update.entryUpdate;
                updateByteSizeDrained += update.heapSize();
                if (entryUpdate.getEntityId() > currentlyIndexedEntityId) continue;
                populatorContext.getVersionContext().initWrite(update.transactionId);
                updater.process(entryUpdate);
            } while (!this.concurrentUpdateQueue.isEmpty());
            this.concurrentUpdateQueueByteSize.addAndGet(-updateByteSizeDrained);
            this.monitor.concurrentUpdatesQueueDrained(updateByteSizeDrained);
        }
    }

    private void forEachPopulation(ThrowingConsumer<IndexPopulation, Exception> action, CursorContext cursorContext) {
        for (IndexPopulation population : this.populations.values()) {
            try {
                action.accept((Object)population);
            }
            catch (Throwable failure) {
                this.cancel(population, failure, cursorContext);
            }
        }
    }

    private PropertyScanConsumer createPropertyScanConsumer() {
        if (this.populations.values().stream().allMatch(population -> population.indexProxyStrategy.getIndexDescriptor().getIndexType() == IndexType.LOOKUP)) {
            return null;
        }
        return new PropertyScanConsumerImpl();
    }

    private TokenScanConsumer createTokenScanConsumer() {
        Optional<IndexPopulation> maybeTokenIdxPopulation = this.populations.values().stream().filter(population -> population.indexProxyStrategy.getIndexDescriptor().getIndexType() == IndexType.LOOKUP).findAny();
        return maybeTokenIdxPopulation.map(x$0 -> new TokenScanConsumerImpl((IndexPopulation)x$0)).orElse(null);
    }

    public String toString() {
        String updatesString = this.populations.values().stream().map(Object::toString).collect(Collectors.joining(", ", "[", "]"));
        return "MultipleIndexPopulator{activeTasks=" + String.valueOf(this.activeTasks) + ", batchedUpdatesFromScan = " + updatesString + ", concurrentUpdateQueue = " + this.concurrentUpdateQueue.size() + "}";
    }

    IndexDescriptor[] indexDescriptors() {
        return (IndexDescriptor[])this.populations.values().stream().map(p -> p.indexProxyStrategy.getIndexDescriptor()).toArray(IndexDescriptor[]::new);
    }

    public void notifyPopulationJobStopped() {
        this.populationJobStopped.setRelease(true);
    }

    public void refreshVisibility(CursorContext cursorContext) {
        cursorContext.getVersionContext().refreshVisibilityBoundaries();
        this.populationHorizon = cursorContext.getVersionContext().lastClosedTransactionId();
        this.forEachPopulation((ThrowingConsumer<IndexPopulation, Exception>)((ThrowingConsumer)population -> population.resetVisibility(cursorContext)), cursorContext);
    }

    public long populationHorison() {
        return this.populationHorizon;
    }

    public void awaitHorizonBeforeScan() {
        this.awaitUntilHorizonReached(this.transactionIdCreatedIndexes);
    }

    private void awaitUntilHorizonReached(long targetTransaction) {
        if (TransactionVisibilityProvider.EMPTY_VISIBILITY_PROVIDER.equals(this.transactionVisibilityProvider)) {
            return;
        }
        while (!this.populationJobStopped.getAcquire() && this.transactionVisibilityProvider.oldestObservableHorizon() < targetTransaction) {
            LockSupport.parkNanos(this.horizonPollIntervalNanos);
            if (!this.needToApplyExternalUpdates()) continue;
            this.applyExternalUpdates(Long.MAX_VALUE);
        }
    }

    public class IndexPopulation
    implements SchemaDescriptorSupplier {
        public final IndexPopulator populator;
        final FlippableIndexProxy flipper;
        private final IndexProxyStrategy indexProxyStrategy;
        private boolean populationOngoing = true;
        private final ReentrantLock populatorLock = new ReentrantLock();
        private long highestClosedTxAtPopulationStart = 1L;

        IndexPopulation(IndexPopulator populator, IndexProxyStrategy indexProxyStrategy, FlippableIndexProxy flipper) {
            this.populator = populator;
            this.indexProxyStrategy = indexProxyStrategy;
            this.flipper = flipper;
        }

        private void cancel(IndexPopulationFailure failure) {
            this.flipper.flipTo(new FailedIndexProxy(this.indexProxyStrategy, (MinimalIndexAccessor)this.populator, failure, MultipleIndexPopulator.this.logProvider));
        }

        void create(CursorContext cursorContext) throws IOException {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    this.populator.create();
                    this.highestClosedTxAtPopulationStart = cursorContext.getVersionContext().highestClosed();
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void resetVisibility(CursorContext cursorContext) {
            this.populatorLock.lock();
            try {
                this.highestClosedTxAtPopulationStart = cursorContext.getVersionContext().highestClosed();
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void disconnectAndStop(CursorContext cursorContext) {
            this.disconnect(() -> this.populator.close(false, cursorContext));
        }

        void disconnectAndDrop() {
            this.disconnect(() -> ((IndexPopulator)this.populator).drop());
        }

        private void disconnect(Runnable specificPopulatorOperation) {
            this.populatorLock.lock();
            try {
                if (this.populationOngoing) {
                    MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
                    specificPopulatorOperation.run();
                    MultipleIndexPopulator.this.resetIndexCountsForPopulation(this);
                    this.populationOngoing = false;
                }
            }
            finally {
                this.populatorLock.unlock();
            }
        }

        void flip(CursorContext cursorContext, boolean awaitHorizon) throws IndexProxyAlreadyClosedKernelException, ExceptionDuringFlipKernelException {
            MultipleIndexPopulator.this.phaseTracker.enterPhase(PhaseTracker.Phase.FLIP);
            if (awaitHorizon && this.populationOngoing) {
                MultipleIndexPopulator.this.awaitUntilHorizonReached(this.highestClosedTxAtPopulationStart);
            }
            this.flipper.flip(() -> {
                this.populatorLock.lock();
                try {
                    if (this.populationOngoing) {
                        MultipleIndexPopulator.this.applyExternalUpdates(Long.MAX_VALUE);
                        IndexDescriptor indexDescriptor = this.indexProxyStrategy.getIndexDescriptor();
                        if (MultipleIndexPopulator.this.populations.containsKey(indexDescriptor)) {
                            if (indexDescriptor.getIndexType() != IndexType.LOOKUP) {
                                IndexSample sample = this.populator.sample(cursorContext);
                                this.indexProxyStrategy.replaceStatisticsForIndex(sample);
                            }
                            this.populator.close(true, cursorContext);
                            MultipleIndexPopulator.this.schemaState.clear();
                            Boolean bl = true;
                            return bl;
                        }
                    }
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    this.logCompletionMessage();
                    this.populationOngoing = false;
                    this.populatorLock.unlock();
                }
            });
            MultipleIndexPopulator.this.removeFromOngoingPopulations(this);
        }

        private void logCompletionMessage() {
            MultipleIndexPopulator.this.log.info("Index creation finished for index [%s].", new Object[]{this.indexProxyStrategy.getIndexUserDescription()});
        }

        public SchemaDescriptor schema() {
            return this.indexProxyStrategy.getIndexDescriptor().schema();
        }

        public String userDescription(TokenNameLookup tokenNameLookup) {
            return this.indexProxyStrategy.getIndexUserDescription();
        }

        void scanCompleted(CursorContext cursorContext) throws IndexEntryConflictException {
            IndexPopulator.PopulationWorkScheduler populationWorkScheduler = new IndexPopulator.PopulationWorkScheduler(){

                public <T> JobHandle<T> schedule(IndexPopulator.JobDescriptionSupplier descriptionSupplier, Callable<T> job) {
                    String description = descriptionSupplier.getJobDescription(IndexPopulation.this.indexProxyStrategy.getIndexDescriptor().getName());
                    JobMonitoringParams jobMonitoringParams = new JobMonitoringParams(MultipleIndexPopulator.this.subject, MultipleIndexPopulator.this.databaseName, description);
                    return MultipleIndexPopulator.this.jobScheduler.schedule(Group.INDEX_POPULATION_WORK, jobMonitoringParams, job);
                }
            };
            this.populator.scanCompleted(MultipleIndexPopulator.this.phaseTracker, populationWorkScheduler, cursorContext);
        }

        PopulationProgress progress(PopulationProgress storeScanProgress) {
            return this.populator.progress(storeScanProgress);
        }
    }

    private class LoggingStoreScan
    implements StoreScan {
        private final StoreScan delegate;
        private final boolean nodeScan;

        LoggingStoreScan(StoreScan delegate, boolean nodeScan) {
            this.delegate = delegate;
            this.nodeScan = nodeScan;
        }

        @Override
        public void run(StoreScan.ExternalUpdatesCheck externalUpdatesCheck) {
            this.delegate.run(externalUpdatesCheck);
            String entityType = this.nodeScan ? "node" : "relationship";
            MultipleIndexPopulator.this.log.debug("Completed " + entityType + " store scan. Flushing all pending updates." + EOL + String.valueOf(MultipleIndexPopulator.this));
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public PopulationProgress getProgress() {
            return this.delegate.getProgress();
        }

        @Override
        public void setPhaseTracker(PhaseTracker phaseTracker) {
            this.delegate.setPhaseTracker(phaseTracker);
        }

        @Override
        public void close() {
            this.delegate.close();
        }
    }

    private record VersionedEntryUpdate(IndexEntryUpdate entryUpdate, long transactionId) {
        long heapSize() {
            return VERSIONED_ENTRY_UPDATE_SIZE + this.entryUpdate.roughSizeOfUpdate();
        }
    }

    static final class MultipleIndexUpdater
    implements AutoCloseable {
        private final MutableLongObjectMap<IndexPopulationUpdater> populationsWithUpdaters;
        private final MultipleIndexPopulator multipleIndexPopulator;
        private final InternalLog log;
        private final CursorContext cursorContext;

        MultipleIndexUpdater(MultipleIndexPopulator multipleIndexPopulator, MutableLongObjectMap<IndexPopulationUpdater> populationsWithUpdaters, InternalLogProvider logProvider, CursorContext cursorContext) {
            this.multipleIndexPopulator = multipleIndexPopulator;
            this.populationsWithUpdaters = populationsWithUpdaters;
            this.log = logProvider.getLog(this.getClass());
            this.cursorContext = cursorContext;
        }

        public void process(IndexEntryUpdate update) {
            IndexPopulationUpdater populationUpdater = (IndexPopulationUpdater)this.populationsWithUpdaters.get(update.indexKey().getId());
            if (populationUpdater != null) {
                IndexPopulation population = populationUpdater.population;
                IndexUpdater updater = populationUpdater.updater;
                try {
                    population.populator.includeSample(update);
                    updater.process(update);
                }
                catch (Throwable t) {
                    try {
                        updater.close();
                    }
                    catch (Throwable ce) {
                        this.log.error(String.format("Failed to close index updater: [%s]", updater), ce);
                    }
                    this.populationsWithUpdaters.remove(update.indexKey().getId());
                    this.multipleIndexPopulator.cancel(population, t, this.cursorContext);
                }
            }
        }

        @Override
        public void close() {
            for (IndexPopulationUpdater populationUpdater : this.populationsWithUpdaters.values()) {
                try {
                    populationUpdater.updater.close();
                }
                catch (Throwable t) {
                    this.multipleIndexPopulator.cancel(populationUpdater.population, t, this.cursorContext);
                }
            }
            this.populationsWithUpdaters.clear();
        }
    }

    private class PropertyScanConsumerImpl
    implements PropertyScanConsumer {
        private PropertyScanConsumerImpl() {
        }

        @Override
        public PropertyScanConsumer.Batch newBatch() {
            return new PropertyScanConsumer.Batch(){
                final List<EntityUpdates> updates = new ArrayList<EntityUpdates>();

                @Override
                public void addRecord(long entityId, int[] tokens, Map<Integer, Value> properties) {
                    EntityUpdates.Builder builder = EntityUpdates.forEntity((long)entityId, (boolean)true).withTokens(tokens);
                    properties.forEach((arg_0, arg_1) -> ((EntityUpdates.Builder)builder).added(arg_0, arg_1));
                    this.updates.add(builder.build());
                }

                @Override
                public void process() {
                    try (CursorContext cursorContext = MultipleIndexPopulator.this.contextFactory.create(MultipleIndexPopulator.POPULATION_WORK_FLUSH_TAG);){
                        PropertyScanConsumerImpl.this.addFromScan(this.updates, cursorContext);
                    }
                }
            };
        }

        private void addFromScan(List<EntityUpdates> entityUpdates, CursorContext cursorContext) {
            HashMap<IndexPopulation, List> updates = new HashMap<IndexPopulation, List>(MultipleIndexPopulator.this.populations.size());
            Set descriptors = MultipleIndexPopulator.this.populations.keySet();
            for (EntityUpdates entityUpdates2 : entityUpdates) {
                for (IndexEntryUpdate indexUpdate : entityUpdates2.valueUpdatesForIndexKeys((Iterable)descriptors)) {
                    IndexPopulation population = MultipleIndexPopulator.this.populations.get(indexUpdate.indexKey());
                    if (population == null) continue;
                    population.populator.includeSample(indexUpdate);
                    updates.computeIfAbsent(population, p -> new ArrayList()).add(indexUpdate);
                }
            }
            for (Map.Entry entry : updates.entrySet()) {
                try {
                    ((IndexPopulation)entry.getKey()).populator.add((Collection)entry.getValue(), cursorContext);
                }
                catch (Throwable e) {
                    MultipleIndexPopulator.this.cancel((IndexPopulation)entry.getKey(), e, cursorContext);
                }
            }
        }
    }

    private class TokenScanConsumerImpl
    implements TokenScanConsumer {
        private final IndexPopulation population;

        TokenScanConsumerImpl(IndexPopulation population) {
            this.population = population;
        }

        @Override
        public TokenScanConsumer.Batch newBatch() {
            return new TokenScanConsumer.Batch(){
                private final List<TokenIndexEntryUpdate> updates = new ArrayList<TokenIndexEntryUpdate>();

                @Override
                public void addRecord(long entityId, int[] tokens) {
                    this.updates.add(TokenIndexEntryUpdate.tokenChange((long)entityId, (IndexDescriptor)TokenScanConsumerImpl.this.population.indexProxyStrategy.getIndexDescriptor(), (int[])ArrayUtils.EMPTY_INT_ARRAY, (int[])tokens));
                }

                @Override
                public void process() {
                    try (CursorContext populationContext = MultipleIndexPopulator.this.cursorContext.createUnboundedReadRelatedContext(MultipleIndexPopulator.MULTIPLE_INDEX_POPULATOR_TAG);){
                        TokenScanConsumerImpl.this.population.populator.add(this.updates, populationContext);
                    }
                    catch (Throwable e) {
                        MultipleIndexPopulator.this.cancel(TokenScanConsumerImpl.this.population, e, MultipleIndexPopulator.this.cursorContext);
                    }
                }
            };
        }
    }

    private record IndexPopulationUpdater(IndexPopulation population, IndexUpdater updater) {
    }
}

