/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.util.List;
import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.kernel.impl.api.CommandCommitListener;
import org.neo4j.storageengine.api.StorageEngineTransaction;

public final class CommandCommitListeners {
    public static final CommandCommitListeners NO_LISTENERS = new CommandCommitListeners(new CommandCommitListener[0]);
    private final List<CommandCommitListener> listeners;

    public static CommandCommitListeners chain(CommandCommitListeners original, CommandCommitListener ... newListeners) {
        if (original == null || original == NO_LISTENERS) {
            return new CommandCommitListeners(newListeners);
        }
        return new CommandCommitListeners((CommandCommitListener[])ArrayUtil.concat((Object[])original.listeners.toArray(new CommandCommitListener[0]), (Object[])newListeners));
    }

    public CommandCommitListeners(CommandCommitListener ... listeners) {
        this.listeners = List.of(listeners);
    }

    public void registerFailure(StorageEngineTransaction commandBatch, Exception exception) {
        for (CommandCommitListener listener : this.listeners) {
            listener.onCommandBatchCommitFailure(commandBatch, exception);
        }
    }

    public void registerSuccess(StorageEngineTransaction commandBatch, long lastAppendIndex) {
        for (CommandCommitListener listener : this.listeners) {
            listener.onCommandBatchCommitSuccess(commandBatch);
        }
    }
}

