/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.vector;

import org.neo4j.kernel.api.vector.VectorUtilSupport;
import org.neo4j.values.VectorCandidate;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.VectorValue;

class DefaultVectorUtilSupport
implements VectorUtilSupport {
    DefaultVectorUtilSupport() {
    }

    public VectorValue scale(VectorCandidate vector, float scale) {
        int dimensions = vector.dimensions();
        float[] scaled = new float[dimensions];
        for (int i = 0; i < dimensions; ++i) {
            scaled[i] = scale * vector.floatValue(i);
        }
        return Values.float32Vector((float[])scaled);
    }

    public float dotProduct(VectorCandidate vector1, VectorCandidate vector2) {
        int dimensions = vector1.dimensions();
        float sum = 0.0f;
        for (int i = 0; i < dimensions; ++i) {
            sum += vector1.floatValue(i) * vector2.floatValue(i);
        }
        return sum;
    }

    public float cosine(VectorCandidate vector1, VectorCandidate vector2) {
        int dimensions = vector1.dimensions();
        float norm1 = 0.0f;
        float norm2 = 0.0f;
        float sum = 0.0f;
        for (int i = 0; i < dimensions; ++i) {
            float element1 = vector1.floatValue(i);
            float element2 = vector2.floatValue(i);
            norm1 += element1 * element1;
            norm2 += element2 * element2;
            sum += element1 * element2;
        }
        return (float)((double)sum / Math.sqrt(norm1 * norm2));
    }

    public float l1Distance(VectorCandidate vector1, VectorCandidate vector2) {
        int dimensions = vector1.dimensions();
        float sum = 0.0f;
        for (int i = 0; i < dimensions; ++i) {
            float diff = vector1.floatValue(i) - vector2.floatValue(i);
            sum += Math.abs(diff);
        }
        return sum;
    }

    public float l1Norm(VectorCandidate vector) {
        int dimensions = vector.dimensions();
        float sum = 0.0f;
        for (int i = 0; i < dimensions; ++i) {
            float element = vector.floatValue(i);
            sum += Math.abs(element);
        }
        return sum;
    }

    public float squareL2Distance(VectorCandidate vector1, VectorCandidate vector2) {
        int dimensions = vector1.dimensions();
        float square = 0.0f;
        for (int i = 0; i < dimensions; ++i) {
            float diff = vector1.floatValue(i) - vector2.floatValue(i);
            square += diff * diff;
        }
        return square;
    }

    public float squareL2Norm(VectorCandidate vector) {
        int dimensions = vector.dimensions();
        float sum = 0.0f;
        for (int i = 0; i < dimensions; ++i) {
            float element = vector.floatValue(i);
            sum += element * element;
        }
        return sum;
    }

    public int hammingDistance(VectorCandidate vector1, VectorCandidate vector2) {
        int dimensions = vector1.dimensions();
        int diff = 0;
        for (int i = 0; i < dimensions; ++i) {
            if (vector1.floatValue(i) == vector2.floatValue(i)) continue;
            ++diff;
        }
        return diff;
    }
}

