/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Arrays;
import java.util.StringJoiner;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.Type;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Values;
import org.neo4j.values.storable.Vector;

public abstract sealed class VectorKeyType
extends Type {
    final int elementSize;

    abstract int arrayCompare(byte[] var1, byte[] var2, int var3);

    private static ValueGroup fromCoordinateType(Vector.CoordinateType coordinateType) {
        return switch (coordinateType) {
            default -> throw new MatchException(null, null);
            case Vector.CoordinateType.INTEGER8 -> ValueGroup.INT8_VECTOR;
            case Vector.CoordinateType.INTEGER16 -> ValueGroup.INT16_VECTOR;
            case Vector.CoordinateType.INTEGER32 -> ValueGroup.INT32_VECTOR;
            case Vector.CoordinateType.INTEGER64 -> ValueGroup.INT64_VECTOR;
            case Vector.CoordinateType.FLOAT32 -> ValueGroup.FLOAT32_VECTOR;
            case Vector.CoordinateType.FLOAT64 -> ValueGroup.FLOAT64_VECTOR;
        };
    }

    private VectorKeyType(Vector.CoordinateType coordinateType, byte typeId, int elementSize) {
        super(VectorKeyType.fromCoordinateType(coordinateType), typeId, null, null);
        this.elementSize = elementSize;
    }

    @Override
    int valueSize(GenericKey<?> state) {
        if (VectorKeyType.isExtremeValue(state)) {
            return 0;
        }
        return 4 + this.elementSize * VectorKeyType.dimension(state);
    }

    private static void setInfinum(GenericKey<?> state) {
        state.long0 = 0L;
    }

    private static void setSuprenum(GenericKey<?> state) {
        state.long0 = 4097L;
    }

    private static boolean isExtremeValue(GenericKey<?> state) {
        return state.long0 == 0L || state.long0 == 4097L;
    }

    private static int dimension(GenericKey<?> state) {
        assert (VectorKeyType.isExtremeValue(state) || state.long0 >= 1L && state.long0 <= 4096L) : "Corrupt state, expected 1<= <value> <= 4096 but was " + state.long0;
        return Math.toIntExact(state.long0);
    }

    @Override
    void copyValue(GenericKey<?> to, GenericKey<?> from) {
        to.long0 = from.long0;
        if (!VectorKeyType.isExtremeValue(from)) {
            int numBytes = this.elementSize * VectorKeyType.dimension(from);
            to.byteArray = VectorKeyType.ensureBigEnough(to.byteArray, numBytes);
            System.arraycopy(from.byteArray, 0, to.byteArray, 0, numBytes);
        }
    }

    @Override
    String toString(GenericKey<?> state) {
        return "VectorKeyType<%s, %s>".formatted(this.valueGroup, VectorKeyType.dimension(state));
    }

    @Override
    protected void addTypeSpecificDetails(StringJoiner joiner, GenericKey<?> state) {
        StringBuilder arr = new StringBuilder();
        int numBytes = this.elementSize * VectorKeyType.dimension(state);
        arr.append("data=[");
        arr.append(state.byteArray[0]);
        for (int i = 1; i < numBytes; ++i) {
            arr.append(", ");
            arr.append(state.byteArray[i]);
        }
        arr.append("]");
        joiner.add(arr.toString());
    }

    @Override
    int compareValue(GenericKey<?> left, GenericKey<?> right) {
        assert (left.type == right.type);
        if (left == right) {
            return 0;
        }
        int comparison = Long.compare(left.long0, right.long0);
        if (comparison != 0) {
            return comparison;
        }
        if (VectorKeyType.isExtremeValue(left)) {
            return 0;
        }
        return this.arrayCompare(left.byteArray, right.byteArray, this.elementSize * VectorKeyType.dimension(left));
    }

    @Override
    void initializeAsLowest(GenericKey<?> state) {
        VectorKeyType.setInfinum(state);
    }

    @Override
    void initializeAsHighest(GenericKey<?> state) {
        VectorKeyType.setSuprenum(state);
    }

    @Override
    void putValue(PageCursor cursor, GenericKey<?> state) {
        assert (!VectorKeyType.isExtremeValue(state)) : "You are not allowed to serialize extreme values";
        int numBytes = this.elementSize * VectorKeyType.dimension(state);
        cursor.putInt((int)state.long0);
        cursor.putBytes(state.byteArray, 0, numBytes);
    }

    @Override
    boolean readValue(PageCursor cursor, int size, GenericKey<?> into) {
        into.long0 = cursor.getInt();
        if (into.long0 < 1L || into.long0 > 4096L) {
            cursor.setCursorException("Corrupt state, expected 1<= <value> <= 4096 but was " + into.long0);
            return false;
        }
        int expectedNumBytes = this.elementSize * VectorKeyType.dimension(into);
        if ((size -= 4) < expectedNumBytes) {
            cursor.setCursorException("Corrupt state, expected %d bytes remaining, but was %d".formatted(expectedNumBytes, size));
            return false;
        }
        into.byteArray = VectorKeyType.ensureBigEnough(into.byteArray, expectedNumBytes);
        cursor.getBytes(into.byteArray, 0, expectedNumBytes);
        return true;
    }

    <KEY extends GenericKey<KEY>> ByteBuffer prepareStateAndGetWriteBuffer(GenericKey<KEY> state, int dimensions) {
        state.long0 = dimensions;
        state.byteArray = VectorKeyType.ensureBigEnough(state.byteArray, this.elementSize * dimensions);
        return ByteBuffer.wrap(state.byteArray, 0, this.elementSize * dimensions);
    }

    static final class Float64VectorKey
    extends VectorKeyType {
        Float64VectorKey(byte typeId) {
            super(Vector.CoordinateType.FLOAT64, typeId, 8);
        }

        @Override
        int arrayCompare(byte[] l, byte[] r, int numBytes) {
            DoubleBuffer lb = ByteBuffer.wrap(l, 0, numBytes).asDoubleBuffer();
            DoubleBuffer rb = ByteBuffer.wrap(r, 0, numBytes).asDoubleBuffer();
            return lb.compareTo(rb);
        }

        void write(GenericKey<?> state, double[] values) {
            ByteBuffer bb = this.prepareStateAndGetWriteBuffer(state, values.length);
            bb.asDoubleBuffer().put(values);
        }

        @Override
        public Value asValue(GenericKey<?> state) {
            DoubleBuffer bb = ByteBuffer.wrap(state.byteArray).asDoubleBuffer();
            double[] copy = new double[VectorKeyType.dimension(state)];
            bb.get(copy, 0, copy.length);
            return Values.float64Vector((double[])copy);
        }
    }

    static final class Float32VectorKey
    extends VectorKeyType {
        Float32VectorKey(byte typeId) {
            super(Vector.CoordinateType.FLOAT32, typeId, 4);
        }

        @Override
        int arrayCompare(byte[] l, byte[] r, int numBytes) {
            FloatBuffer lb = ByteBuffer.wrap(l, 0, numBytes).asFloatBuffer();
            FloatBuffer rb = ByteBuffer.wrap(r, 0, numBytes).asFloatBuffer();
            return lb.compareTo(rb);
        }

        void write(GenericKey<?> state, float[] values) {
            ByteBuffer bb = this.prepareStateAndGetWriteBuffer(state, values.length);
            bb.asFloatBuffer().put(values);
        }

        @Override
        public Value asValue(GenericKey<?> state) {
            FloatBuffer bb = ByteBuffer.wrap(state.byteArray).asFloatBuffer();
            float[] copy = new float[VectorKeyType.dimension(state)];
            bb.get(copy, 0, copy.length);
            return Values.float32Vector((float[])copy);
        }
    }

    static final class Int64VectorKey
    extends VectorKeyType {
        Int64VectorKey(byte typeId) {
            super(Vector.CoordinateType.INTEGER64, typeId, 8);
        }

        void write(GenericKey<?> state, long[] values) {
            ByteBuffer bb = this.prepareStateAndGetWriteBuffer(state, values.length);
            bb.asLongBuffer().put(values);
        }

        @Override
        int arrayCompare(byte[] l, byte[] r, int numBytes) {
            LongBuffer lb = ByteBuffer.wrap(l, 0, numBytes).asLongBuffer();
            LongBuffer rb = ByteBuffer.wrap(r, 0, numBytes).asLongBuffer();
            return lb.compareTo(rb);
        }

        @Override
        public Value asValue(GenericKey<?> state) {
            LongBuffer bb = ByteBuffer.wrap(state.byteArray).asLongBuffer();
            long[] copy = new long[VectorKeyType.dimension(state)];
            bb.get(copy, 0, copy.length);
            return Values.int64Vector((long[])copy);
        }
    }

    static final class Int32VectorKey
    extends VectorKeyType {
        Int32VectorKey(byte typeId) {
            super(Vector.CoordinateType.INTEGER32, typeId, 4);
        }

        void write(GenericKey<?> state, int[] values) {
            ByteBuffer bb = this.prepareStateAndGetWriteBuffer(state, values.length);
            bb.asIntBuffer().put(values);
        }

        @Override
        int arrayCompare(byte[] l, byte[] r, int numBytes) {
            IntBuffer lb = ByteBuffer.wrap(l, 0, numBytes).asIntBuffer();
            IntBuffer rb = ByteBuffer.wrap(r, 0, numBytes).asIntBuffer();
            return lb.compareTo(rb);
        }

        @Override
        public Value asValue(GenericKey<?> state) {
            IntBuffer bb = ByteBuffer.wrap(state.byteArray).asIntBuffer();
            int[] copy = new int[VectorKeyType.dimension(state)];
            bb.get(copy, 0, copy.length);
            return Values.int32Vector((int[])copy);
        }
    }

    static final class Int16VectorKey
    extends VectorKeyType {
        Int16VectorKey(byte typeId) {
            super(Vector.CoordinateType.INTEGER16, typeId, 2);
        }

        void write(GenericKey<?> state, short[] values) {
            ByteBuffer bb = this.prepareStateAndGetWriteBuffer(state, values.length);
            bb.asShortBuffer().put(values);
        }

        @Override
        int arrayCompare(byte[] l, byte[] r, int numBytes) {
            ShortBuffer lb = ByteBuffer.wrap(l, 0, numBytes).asShortBuffer();
            ShortBuffer rb = ByteBuffer.wrap(r, 0, numBytes).asShortBuffer();
            return lb.compareTo(rb);
        }

        @Override
        public Value asValue(GenericKey<?> state) {
            ByteBuffer bb = ByteBuffer.wrap(state.byteArray);
            ShortBuffer sb = bb.asShortBuffer();
            short[] copy = new short[VectorKeyType.dimension(state)];
            sb.get(copy, 0, copy.length);
            return Values.int16Vector((short[])copy);
        }
    }

    static final class Int8VectorKey
    extends VectorKeyType {
        Int8VectorKey(byte typeId) {
            super(Vector.CoordinateType.INTEGER8, typeId, 1);
        }

        public void write(GenericKey<?> state, byte[] values) {
            ByteBuffer bb = this.prepareStateAndGetWriteBuffer(state, values.length);
            bb.put(values);
        }

        @Override
        int arrayCompare(byte[] left, byte[] right, int numBytes) {
            return Arrays.compare(left, 0, numBytes, right, 0, numBytes);
        }

        @Override
        public Value asValue(GenericKey<?> state) {
            ByteBuffer bb = ByteBuffer.wrap(state.byteArray);
            byte[] copy = new byte[this.elementSize * VectorKeyType.dimension(state)];
            bb.get(copy, 0, copy.length);
            return Values.int8Vector((byte[])copy);
        }
    }
}

