/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.function.Consumer;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.DatabaseIndexContext;
import org.neo4j.kernel.impl.index.schema.FailureHeaderWriter;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.TokenIndex;
import org.neo4j.kernel.impl.index.schema.TokenIndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.Preconditions;

public class TokenIndexPopulator
extends TokenIndex
implements IndexPopulator {
    private byte[] failureBytes;
    private boolean dropped;
    private boolean closed;

    TokenIndexPopulator(DatabaseIndexContext databaseIndexContext, IndexFiles indexFiles, IndexDescriptor descriptor, ImmutableSet<OpenOption> openOptions, StorageEngineIndexingBehaviour indexingBehaviour) {
        super(databaseIndexContext, indexFiles, descriptor, openOptions, false, indexingBehaviour);
    }

    public synchronized void create() {
        this.assertNotDropped();
        this.assertNotClosed();
        this.indexFiles.clear();
        this.instantiateTree(RecoveryCleanupWorkCollector.immediate());
        this.instantiateUpdater();
    }

    public synchronized void drop() {
        try {
            if (this.index != null) {
                this.index.setDeleteOnClose(true);
            }
            this.closeResources();
            this.indexFiles.clear();
        }
        finally {
            this.dropped = true;
            this.closed = true;
        }
    }

    public void add(Collection<? extends IndexEntryUpdate> updates, CursorContext cursorContext) throws IndexEntryConflictException {
        try (TokenIndexUpdater updater = this.singleUpdater.initialize(context -> this.index.writer(1, context), false, cursorContext);){
            for (IndexEntryUpdate indexEntryUpdate : updates) {
                updater.process(indexEntryUpdate);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public IndexUpdater newPopulatingUpdater(CursorContext cursorContext) {
        try {
            return this.singleUpdater.initialize(context -> this.index.writer(1, context), false, cursorContext);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(boolean populationCompletedSuccessfully, CursorContext cursorContext) {
        block16: {
            Preconditions.checkState((!populationCompletedSuccessfully || this.failureBytes == null ? 1 : 0) != 0, (String)"Can't mark index as online after it has been marked as failure");
            try {
                this.assertNotDropped();
                if (populationCompletedSuccessfully) {
                    this.assertTreeOpen();
                    try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
                        this.flushTreeAndMarkAs((byte)0, flushEvent, cursorContext);
                        break block16;
                    }
                }
                if (this.failureBytes == null) break block16;
                this.ensureTreeInstantiated();
                try (FileFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush();){
                    this.markTreeAsFailed(flushEvent, cursorContext);
                }
            }
            finally {
                this.closeResources();
                this.closed = true;
            }
        }
    }

    private void flushTreeAndMarkAs(byte state, FileFlushEvent flushEvent, CursorContext cursorContext) {
        this.index.checkpoint(pageCursor -> pageCursor.putByte(state), flushEvent, cursorContext);
    }

    private void markTreeAsFailed(FileFlushEvent flushEvent, CursorContext cursorContext) {
        Preconditions.checkState((this.failureBytes != null ? 1 : 0) != 0, (String)"markAsFailed hasn't been called, populator not actually failed?");
        this.index.checkpoint((Consumer)new FailureHeaderWriter(this.failureBytes, 2), flushEvent, cursorContext);
    }

    public void markAsFailed(String failure) {
        this.failureBytes = failure.getBytes(StandardCharsets.UTF_8);
    }

    public void includeSample(IndexEntryUpdate update) {
    }

    public IndexSample sample(CursorContext cursorContext) {
        throw new UnsupportedOperationException("Token indexes does not support index sampling");
    }

    private void assertNotDropped() {
        Preconditions.checkState((!this.dropped ? 1 : 0) != 0, (String)"Populator has already been dropped.");
    }

    private void assertNotClosed() {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (String)"Populator has already been closed.");
    }

    private void ensureTreeInstantiated() {
        if (this.index == null) {
            this.instantiateTree(RecoveryCleanupWorkCollector.ignore());
        }
    }
}

