/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.ArrayList;
import java.util.Collection;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.storageengine.api.IndexEntryUpdate;

public class CollectingIndexUpdater
implements IndexUpdater {
    private final CursorContext cursorContext;
    private final Applier applier;
    private boolean closed;
    private final Collection<VersionedUpdate> updates = new ArrayList<VersionedUpdate>();

    public CollectingIndexUpdater(CursorContext cursorContext, Applier applier) {
        this.cursorContext = cursorContext;
        this.applier = applier;
    }

    public void process(IndexEntryUpdate update) {
        this.assertOpen();
        this.updates.add(new VersionedUpdate(update, this.cursorContext.getVersionContext().committingTransactionId()));
    }

    public void close() throws IndexEntryConflictException {
        this.assertOpen();
        try {
            this.applier.accept(this.updates);
        }
        finally {
            this.closed = true;
        }
    }

    private void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException("Updater has been closed");
        }
    }

    public static interface Applier {
        public void accept(Collection<VersionedUpdate> var1) throws IndexEntryConflictException;
    }

    public record VersionedUpdate(IndexEntryUpdate update, long version) {
    }
}

