/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.transaction.trace;

import java.util.concurrent.ThreadLocalRandom;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.kernel.impl.api.transaction.trace.TraceProvider;
import org.neo4j.kernel.impl.api.transaction.trace.TransactionInitializationTrace;

public class TraceProviderFactory {
    private TraceProviderFactory() {
    }

    public static TraceProvider getTraceProvider(Config config) {
        GraphDatabaseSettings.TransactionTracingLevel tracingLevel = (GraphDatabaseSettings.TransactionTracingLevel)config.get(GraphDatabaseSettings.transaction_tracing_level);
        return switch (tracingLevel) {
            default -> throw new MatchException(null, null);
            case GraphDatabaseSettings.TransactionTracingLevel.DISABLED -> () -> TransactionInitializationTrace.NONE;
            case GraphDatabaseSettings.TransactionTracingLevel.ALL -> TransactionInitializationTrace::new;
            case GraphDatabaseSettings.TransactionTracingLevel.SAMPLE -> () -> {
                if (ThreadLocalRandom.current().nextInt(1, 101) <= (Integer)config.get(GraphDatabaseSettings.transaction_sampling_percentage)) {
                    return new TransactionInitializationTrace();
                }
                return TransactionInitializationTrace.NONE;
            };
        };
    }
}

