/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.chunk;

import java.util.function.LongConsumer;
import org.neo4j.common.Subject;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.VersionContext;
import org.neo4j.kernel.impl.api.chunk.ChunkedCommandBatch;
import org.neo4j.kernel.impl.api.txid.TransactionIdGenerator;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.CommandBatch;
import org.neo4j.storageengine.api.Commitment;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class ChunkedTransaction
implements StorageEngineTransaction {
    private ChunkedCommandBatch chunk;
    private final CursorContext cursorContext;
    private final long transactionSequenceNumber;
    private final StoreCursors storeCursors;
    private final Commitment commitment;
    private final TransactionIdGenerator transactionIdGenerator;
    private boolean idGenerated;
    private long lastBatchAppendIndex = 0L;
    private long transactionId = 0L;
    private StorageEngineTransaction next;
    private long firstAppendIndex;
    private LongConsumer closedCallback;

    public ChunkedTransaction(CursorContext cursorContext, long transactionSequenceNumber, StoreCursors storeCursors, Commitment commitment, TransactionIdGenerator transactionIdGenerator) {
        this.cursorContext = cursorContext;
        this.transactionSequenceNumber = transactionSequenceNumber;
        this.storeCursors = storeCursors;
        this.commitment = commitment;
        this.transactionIdGenerator = transactionIdGenerator;
    }

    public ChunkedTransaction(CommittedCommandBatchRepresentation committedCommandBatchRepresentation, CursorContext cursorContext, StoreCursors storeCursors) {
        this(committedCommandBatchRepresentation.txId(), -1L, cursorContext, storeCursors);
        this.init((ChunkedCommandBatch)committedCommandBatchRepresentation.commandBatch());
    }

    public ChunkedTransaction(long transactionId, long transactionSequenceNumber, CursorContext cursorContext, StoreCursors storeCursors) {
        this(cursorContext, transactionSequenceNumber, storeCursors, Commitment.NO_COMMITMENT, TransactionIdGenerator.EXTERNAL_ID);
        this.transactionId = transactionId;
        this.idGenerated = true;
    }

    public ChunkedTransaction(long transactionId, long appendIndex, long transactionSequenceNumber, CursorContext cursorContext, StoreCursors storeCursors, Commitment commitment) {
        this(cursorContext, transactionSequenceNumber, storeCursors, commitment, TransactionIdGenerator.EXTERNAL_ID);
        this.transactionId = transactionId;
        this.lastBatchAppendIndex = appendIndex;
        this.idGenerated = true;
    }

    public void init(ChunkedCommandBatch chunk) {
        this.chunk = chunk;
    }

    public Subject subject() {
        return this.chunk.subject();
    }

    public long transactionId() {
        if (this.idGenerated) {
            return this.transactionId;
        }
        this.transactionId = this.transactionIdGenerator.nextId(this.transactionId);
        this.idGenerated = true;
        return this.transactionId;
    }

    public long chunkId() {
        return this.chunk.chunkMetadata().chunkId();
    }

    public long previousBatchAppendIndex() {
        return this.chunk.chunkMetadata().previousBatchAppendIndex();
    }

    public CursorContext cursorContext() {
        return this.cursorContext;
    }

    public StoreCursors storeCursors() {
        return this.storeCursors;
    }

    public StorageEngineTransaction next() {
        return this.next;
    }

    public void next(StorageEngineTransaction next) {
        this.next = next;
    }

    public void onClose(LongConsumer closedCallback) {
        this.closedCallback = closedCallback;
    }

    public void commit() {
        this.commitment.publishAsCommitedLastBatch();
        if (this.chunk.isLast()) {
            this.commitment.publishAsCommitted(this.chunk.chunkMetadata().chunkCommitTime(), this.firstAppendIndex);
        }
    }

    public long lastBatchAppendIndex() {
        return this.lastBatchAppendIndex;
    }

    public CommandBatch commandBatch() {
        return this.chunk;
    }

    public void batchAppended(long appendIndex, LogPosition beforeStart, LogPosition positionAfter, int checksum) {
        VersionContext versionContext = this.cursorContext.getVersionContext();
        if (this.chunk.isFirst()) {
            versionContext.initWrite(this.transactionId);
            this.firstAppendIndex = appendIndex;
        }
        this.commitment.commit(this.transactionId, appendIndex, this.chunk.chunkMetadata().first(), this.chunk.chunkMetadata().last(), this.chunk.kernelVersion(), beforeStart, positionAfter, checksum, this.chunk.chunkMetadata().consensusIndex().longValue());
        versionContext.initAppendIndex(appendIndex);
        this.chunk.setAppendIndex(appendIndex);
        this.lastBatchAppendIndex = appendIndex;
    }

    public void close() {
        this.commitment.publishAsClosed();
        if (this.chunk.isLast() && this.closedCallback != null) {
            this.closedCallback.accept(this.transactionId);
        }
    }

    public String toString() {
        return "ChunkedTransaction{transactionSequenceNumber=" + this.transactionSequenceNumber + ", transactionId=" + this.transactionId + ", chunkId=" + this.chunk.chunkMetadata().chunkId() + "}";
    }

    public long getTransactionSequenceNumber() {
        return this.transactionSequenceNumber;
    }

    public void updateClusteredInfo(long transactionId, long appendIndex) {
        if (!this.idGenerated) {
            this.transactionId = transactionId;
            this.firstAppendIndex = appendIndex;
            this.cursorContext.getVersionContext().initWrite(transactionId);
            this.idGenerated = true;
        }
        this.cursorContext.getVersionContext().initAppendIndex(appendIndex);
        this.lastBatchAppendIndex = appendIndex;
    }
}

