/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.exceptions.schema;

import org.neo4j.common.TokenNameLookup;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.internal.kernel.api.exceptions.schema.SchemaKernelException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.kernel.api.exceptions.Status;

public class AlreadyConstrainedException
extends SchemaKernelException {
    private static final String ALREADY_CONSTRAINED_MESSAGE_PREFIX = "Constraint already exists: ";
    private static final String INDEX_CONTEXT_FORMAT = "There is a uniqueness constraint on %s, so an index is already created that matches this.";

    private AlreadyConstrainedException(String message, ErrorGqlStatusObject gqlStatusObject) {
        super(gqlStatusObject, (Status)Status.Schema.ConstraintAlreadyExists, message);
    }

    public static AlreadyConstrainedException cannotCreateIndex(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup) {
        String constraintName = constraint.getName();
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N74).withParam(GqlParams.StringParam.constr, constraintName).withCause(ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N70).withParam(GqlParams.StringParam.idxDescrOrName, constraintName).build()).build();
        String message = AlreadyConstrainedException.messageWithLabelAndPropertyName((TokenNameLookup)tokenNameLookup, (String)INDEX_CONTEXT_FORMAT, (SchemaDescriptor)constraint.schema());
        return new AlreadyConstrainedException(message, gql);
    }

    public static AlreadyConstrainedException cannotCreateConstraint(ConstraintDescriptor constraint, TokenNameLookup tokenNameLookup) {
        String constraintName = constraint.getName();
        String constraintUD = constraint.userDescription(tokenNameLookup);
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_22N65).withParam(GqlParams.StringParam.constrDescrOrName, constraintName).build();
        String message = ALREADY_CONSTRAINED_MESSAGE_PREFIX + constraintUD;
        return new AlreadyConstrainedException(message, gql);
    }
}

