/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.schema;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.factory.Maps;
import org.neo4j.graphdb.schema.IndexSetting;
import org.neo4j.graphdb.schema.IndexSettingImpl;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.util.VisibleForTesting;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class IndexSettingUtil {
    public static final int DEFAULT_VECTOR_DIMENSIONS = 1024;
    private static final Map<String, IndexSetting> INDEX_SETTING_REVERSE_LOOKUP = Map.ofEntries((Map.Entry[])Stream.of(IndexSettingImpl.values()).map(s -> Map.entry(s.getSettingName(), s)).toArray(Map.Entry[]::new));

    public static Map<IndexSetting, Object> toIndexSettingObjectMapFromIndexConfig(IndexConfig indexConfig) {
        MutableMap asMap = Maps.mutable.of();
        for (Pair entry : indexConfig.entries()) {
            IndexSetting key = IndexSettingUtil.fromString((String)entry.getOne());
            if (key == null) continue;
            Object value = ((Value)entry.getTwo()).asObjectCopy();
            asMap.put(key, value);
        }
        return Collections.unmodifiableMap(asMap);
    }

    public static IndexConfig toIndexConfigFromIndexSettingObjectMap(Map<IndexSetting, Object> indexConfiguration) {
        HashMap<String, Value> collectingMap = new HashMap<String, Value>();
        for (Map.Entry<IndexSetting, Object> entry : indexConfiguration.entrySet()) {
            IndexSetting setting = entry.getKey();
            Value value = IndexSettingUtil.asIndexSettingValue(setting, entry.getValue());
            collectingMap.put(setting.getSettingName(), value);
        }
        return IndexConfig.with(collectingMap);
    }

    public static IndexConfig toIndexConfigFromStringObjectMap(Map<String, Object> configMap) {
        HashMap<IndexSetting, Object> collectingMap = new HashMap<IndexSetting, Object>();
        for (Map.Entry<String, Object> entry : configMap.entrySet()) {
            String key = entry.getKey();
            IndexSetting indexSetting = IndexSettingUtil.asIndexSetting(key);
            collectingMap.put(indexSetting, entry.getValue());
        }
        return IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(collectingMap);
    }

    public static IndexSetting spatialMinSettingForCrs(CoordinateReferenceSystem crs) {
        return switch (crs.getName()) {
            case "cartesian" -> IndexSettingImpl.SPATIAL_CARTESIAN_MIN;
            case "cartesian-3d" -> IndexSettingImpl.SPATIAL_CARTESIAN_3D_MIN;
            case "wgs-84" -> IndexSettingImpl.SPATIAL_WGS84_MIN;
            case "wgs-84-3d" -> IndexSettingImpl.SPATIAL_WGS84_3D_MIN;
            default -> throw new IllegalArgumentException("Unrecognized coordinate reference system " + String.valueOf(crs));
        };
    }

    public static IndexSetting spatialMaxSettingForCrs(CoordinateReferenceSystem crs) {
        return switch (crs.getName()) {
            case "cartesian" -> IndexSettingImpl.SPATIAL_CARTESIAN_MAX;
            case "cartesian-3d" -> IndexSettingImpl.SPATIAL_CARTESIAN_3D_MAX;
            case "wgs-84" -> IndexSettingImpl.SPATIAL_WGS84_MAX;
            case "wgs-84-3d" -> IndexSettingImpl.SPATIAL_WGS84_3D_MAX;
            default -> throw new IllegalArgumentException("Unrecognized coordinate reference system " + String.valueOf(crs));
        };
    }

    @VisibleForTesting
    public static Map<IndexSetting, Object> defaultSettingsForTesting(IndexType type) {
        return switch (type) {
            case IndexType.VECTOR -> Map.of(IndexSetting.vector_Dimensions(), 1024, IndexSetting.vector_Similarity_Function(), "COSINE");
            default -> Map.of();
        };
    }

    @VisibleForTesting
    public static IndexConfig defaultConfigForTest(IndexType type) {
        return IndexSettingUtil.toIndexConfigFromIndexSettingObjectMap(IndexSettingUtil.defaultSettingsForTesting(type));
    }

    private static IndexSetting fromString(String string) {
        return INDEX_SETTING_REVERSE_LOOKUP.get(string);
    }

    private static IndexSetting asIndexSetting(String key) {
        IndexSetting indexSetting = IndexSettingUtil.fromString(key);
        if (indexSetting == null) {
            throw new IllegalArgumentException(String.format("Invalid index config key '%s', it was not recognized as an index setting.", key));
        }
        return indexSetting;
    }

    @VisibleForTesting
    static Value asIndexSettingValue(IndexSetting setting, Object value) {
        Objects.requireNonNull(value, "Index setting value can not be null.");
        return IndexSettingUtil.parse(setting, value);
    }

    private static Value parse(IndexSetting indexSetting, Object value) {
        Class type = indexSetting.getType();
        try {
            if (type == Boolean.class) {
                return IndexSettingUtil.parseAsBoolean(value);
            }
            if (type == double[].class) {
                return IndexSettingUtil.parseAsDoubleArray(value);
            }
            if (type == String.class) {
                return Values.stringValue((String)value.toString());
            }
            if (type == Integer.class) {
                return IndexSettingUtil.parseAsInteger(value);
            }
        }
        catch (IndexSettingParseException e) {
            throw new IllegalArgumentException("Invalid value type for '" + indexSetting.getSettingName() + "' setting. Expected a value of type " + type.getName() + ", but got value '" + String.valueOf(value) + "' of type " + (value == null ? "null" : value.getClass().getName()) + ".", e);
        }
        throw new UnsupportedOperationException("Should not happen. Missing parser for type " + type.getSimpleName() + ". This type is used by indexSetting " + indexSetting.getSettingName());
    }

    private static IntValue parseAsInteger(Object value) throws IndexSettingParseException {
        if (value instanceof Number) {
            return Values.intValue((int)((Number)value).intValue());
        }
        throw new IndexSettingParseException("Could not parse value '" + String.valueOf(value) + "' of type " + value.getClass().getSimpleName() + " as integer.");
    }

    private static DoubleArray parseAsDoubleArray(Object value) throws IndexSettingParseException {
        if (value instanceof byte[]) {
            double[] doubleArray = IndexSettingUtil.toDoubleArray((byte[])value);
            return Values.doubleArray((double[])doubleArray);
        }
        if (value instanceof short[]) {
            double[] doubleArray = IndexSettingUtil.toDoubleArray((short[])value);
            return Values.doubleArray((double[])doubleArray);
        }
        if (value instanceof int[]) {
            double[] doubleArray = IndexSettingUtil.toDoubleArray((int[])value);
            return Values.doubleArray((double[])doubleArray);
        }
        if (value instanceof long[]) {
            double[] doubleArray = IndexSettingUtil.toDoubleArray((long[])value);
            return Values.doubleArray((double[])doubleArray);
        }
        if (value instanceof float[]) {
            double[] doubleArray = IndexSettingUtil.toDoubleArray((float[])value);
            return Values.doubleArray((double[])doubleArray);
        }
        if (value instanceof double[]) {
            return Values.doubleArray((double[])((double[])value));
        }
        if (value instanceof Number[]) {
            Number[] numberArray = (Number[])value;
            double[] doubleArray = new double[numberArray.length];
            for (int i = 0; i < numberArray.length; ++i) {
                doubleArray[i] = numberArray[i].doubleValue();
            }
            return Values.doubleArray((double[])doubleArray);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            double[] doubleArray = new double[collection.size()];
            Iterator iterator = collection.iterator();
            int i = 0;
            while (iterator.hasNext()) {
                Object next = iterator.next();
                if (!(next instanceof Number)) {
                    throw new IndexSettingParseException("Could not parse value '" + String.valueOf(value) + "' of type " + next.getClass().getSimpleName() + " as double.");
                }
                doubleArray[i] = ((Number)next).doubleValue();
                ++i;
            }
            return Values.doubleArray((double[])doubleArray);
        }
        throw new IndexSettingParseException("Could not parse value '" + String.valueOf(value) + "' as double[].");
    }

    private static BooleanValue parseAsBoolean(Object value) throws IndexSettingParseException {
        if (value instanceof Boolean) {
            return Values.booleanValue((boolean)((Boolean)value));
        }
        throw new IndexSettingParseException("Could not parse value '" + String.valueOf(value) + "' as boolean.");
    }

    private static double[] toDoubleArray(byte[] value) {
        double[] doubleArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            doubleArray[i] = value[i];
        }
        return doubleArray;
    }

    private static double[] toDoubleArray(short[] value) {
        double[] doubleArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            doubleArray[i] = value[i];
        }
        return doubleArray;
    }

    private static double[] toDoubleArray(int[] value) {
        double[] doubleArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            doubleArray[i] = value[i];
        }
        return doubleArray;
    }

    private static double[] toDoubleArray(long[] value) {
        double[] doubleArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            doubleArray[i] = value[i];
        }
        return doubleArray;
    }

    private static double[] toDoubleArray(float[] value) {
        double[] doubleArray = new double[value.length];
        for (int i = 0; i < value.length; ++i) {
            doubleArray[i] = value[i];
        }
        return doubleArray;
    }

    private static class IndexSettingParseException
    extends Exception {
        IndexSettingParseException(String message) {
            super(message);
        }
    }
}

