/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.exceptions.UpgradeException;
import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintCreator;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.IndexCreator;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.IndexType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Pair;
import org.neo4j.util.Preconditions;
import org.neo4j.util.VisibleForTesting;

public abstract class AbstractSystemGraphComponent
implements SystemGraphComponent {
    protected final Config config;

    public AbstractSystemGraphComponent(Config config) {
        this.config = config;
    }

    protected void initializeSystemGraphSchema(GraphDatabaseService system) throws Exception {
    }

    protected void initializeSystemGraphModel(Transaction tx, GraphDatabaseService systemDb) throws Exception {
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
    }

    protected void initializeSystemGraphModel(GraphDatabaseService system) throws Exception {
        try (Transaction tx = system.beginTx();){
            this.initializeSystemGraphModel(tx, system);
            tx.commit();
        }
    }

    protected void postInitialization(GraphDatabaseService system, boolean wasInitialized) throws Exception {
    }

    @Override
    public void initializeSystemGraph(GraphDatabaseService system, boolean firstInitialization) throws Exception {
        boolean mayUpgrade = (Boolean)this.config.get(GraphDatabaseInternalSettings.automatic_upgrade_enabled);
        Preconditions.checkState((boolean)system.databaseName().equals("system"), (String)("Cannot initialize system graph on database '" + system.databaseName() + "'"));
        SystemGraphComponent.Status status = this.detect(system);
        if (status == SystemGraphComponent.Status.UNINITIALIZED) {
            this.initializeSystemGraphSchema(system);
            this.initializeSystemGraphModel(system);
            this.postInitialization(system, true);
        } else if (status == SystemGraphComponent.Status.CURRENT || status == SystemGraphComponent.Status.REQUIRES_UPGRADE && !mayUpgrade) {
            this.verifySystemGraph(system);
            this.postInitialization(system, false);
        } else if (mayUpgrade && status == SystemGraphComponent.Status.REQUIRES_UPGRADE || status == SystemGraphComponent.Status.UNSUPPORTED_BUT_CAN_UPGRADE) {
            this.upgradeToCurrent(system);
        } else {
            throw new IllegalStateException(String.format("Unsupported component state for '%s': %s", this.componentName(), status.description()));
        }
    }

    protected static void initializeSystemGraphConstraint(GraphDatabaseService system, Label label, String ... properties) throws Exception {
        AbstractSystemGraphComponent.initializeSystemGraphConstraint(system, Optional.empty(), label, properties);
    }

    protected static void initializeDisplayNameSystemGraphConstraint(GraphDatabaseService system) throws Exception {
        try {
            AbstractSystemGraphComponent.initializeSystemGraphConstraint(system, Optional.of("displayNameConstraint"), TopologyGraphDbmsModel.DATABASE_NAME_LABEL, "displayName");
        }
        catch (ConstraintViolationException e) {
            Optional<Pair<String, String>> conflictingDbs = AbstractSystemGraphComponent.findDisplayNameConflicts(system);
            if (conflictingDbs.isPresent()) {
                throw UpgradeException.conflictingDisplayNames((String)((String)conflictingDbs.get().first()), (String)((String)conflictingDbs.get().other()));
            }
            throw e;
        }
    }

    @VisibleForTesting
    public static Optional<Pair<String, String>> findDisplayNameConflicts(GraphDatabaseService system) {
        Optional<Pair<String, String>> maybeConflict;
        try (Transaction tx = system.beginTx();){
            Map<Object, List<Node>> databasesPerDisplayName = tx.findNodes(TopologyGraphDbmsModel.DATABASE_NAME_LABEL).stream().collect(Collectors.groupingBy(node -> node.getProperty("displayName")));
            maybeConflict = databasesPerDisplayName.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).min(Comparator.comparing(entry -> entry.getKey().toString())).map(entry -> {
                List<String> conflicts = ((List)entry.getValue()).stream().map(node -> node.getProperty("name").toString()).sorted().toList();
                return Pair.of((Object)conflicts.get(0), (Object)conflicts.get(1));
            });
            tx.rollback();
        }
        return maybeConflict;
    }

    protected static void initializeSystemGraphConstraint(GraphDatabaseService system, Optional<String> name, Label label, String ... properties) throws Exception {
        AtomicBoolean hasUniqueConstraint = new AtomicBoolean(false);
        SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> hasUniqueConstraint.set(AbstractSystemGraphComponent.hasUniqueConstraint(tx, label, properties))));
        if (!hasUniqueConstraint.get()) {
            SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> AbstractSystemGraphComponent.checkForClashingIndexes(tx, label, properties)));
            SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
                ConstraintCreator cb = tx.schema().constraintFor(label);
                for (String prop : properties) {
                    cb = cb.assertPropertyIsUnique(prop);
                }
                if (name.isEmpty()) {
                    cb.create();
                } else {
                    cb.withName((String)name.get()).create();
                }
            }));
        }
    }

    protected static void initialiseSystemGraphIndex(GraphDatabaseService system, String indexName, Label label, String ... properties) throws Exception {
        SystemGraphComponent.executeWithFullAccess(system, (ThrowingConsumer<Transaction, Exception>)((ThrowingConsumer)tx -> {
            if (!AbstractSystemGraphComponent.hasIndex(tx, label, properties)) {
                IndexCreator ic = tx.schema().indexFor(label).withName(indexName);
                ic.withIndexType(IndexType.RANGE);
                for (String prop : properties) {
                    ic = ic.on(prop);
                }
                ic.create();
            }
        }));
    }

    private static boolean hasIndex(Transaction tx, Label label, String ... properties) {
        for (IndexDefinition index : tx.schema().getIndexes(label)) {
            if (!index.getPropertyKeys().equals(Arrays.asList(properties))) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasUniqueConstraint(Transaction tx, Label label, String ... properties) {
        return AbstractSystemGraphComponent.findUniqueConstraint(tx, label, properties).isPresent();
    }

    protected static Optional<ConstraintDefinition> findUniqueConstraint(Transaction tx, Label label, String ... properties) {
        for (ConstraintDefinition constraintDefinition : tx.schema().getConstraints(label)) {
            if (!constraintDefinition.getPropertyKeys().equals(Arrays.asList(properties)) || !constraintDefinition.isConstraintType(ConstraintType.UNIQUENESS)) continue;
            return Optional.of(constraintDefinition);
        }
        return Optional.empty();
    }

    private static void checkForClashingIndexes(Transaction tx, Label label, String ... properties) {
        tx.schema().getIndexes(label).forEach(index -> {
            Object[] propertyKeys = (String[])Iterables.asArray(String.class, (Iterable)index.getPropertyKeys());
            if (Arrays.equals(propertyKeys, properties)) {
                index.drop();
            }
        });
    }
}

