/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.coreapi.schema;

import java.util.Arrays;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.schema.ConstraintType;
import org.neo4j.graphdb.schema.PropertyType;
import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.constraints.ConstrainableType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.kernel.impl.coreapi.schema.InternalSchemaActions;
import org.neo4j.kernel.impl.coreapi.schema.RelationshipConstraintDefinition;

public class RelationshipPropertyTypeConstraintDefinition
extends RelationshipConstraintDefinition {
    public RelationshipPropertyTypeConstraintDefinition(InternalSchemaActions actions, ConstraintDescriptor constraint, RelationshipType relationshipType, String propertyKey) {
        super(actions, constraint, relationshipType, propertyKey);
    }

    public ConstraintType getConstraintType() {
        this.assertInUnterminatedTransaction();
        return ConstraintType.RELATIONSHIP_PROPERTY_TYPE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RelationshipPropertyTypeConstraintDefinition that = (RelationshipPropertyTypeConstraintDefinition)o;
        return this.relationshipType.name().equals(that.relationshipType.name()) && Arrays.equals(this.propertyKeys, that.propertyKeys) && this.constraint.asPropertyTypeConstraint().propertyType().equals((Object)that.constraint.asPropertyTypeConstraint().propertyType());
    }

    @Override
    public int hashCode() {
        int result = 31 * this.relationshipType.name().hashCode();
        result = 31 * result + Arrays.hashCode(this.propertyKeys);
        result = 31 * result + this.constraint.asPropertyTypeConstraint().propertyType().hashCode();
        return result;
    }

    @Override
    public String toString() {
        String relationshipTypeName = NameUtil.escapeName((String)this.relationshipType.name());
        return String.format("FOR ()-[%s:%s]-() REQUIRE %s IS :: %s", relationshipTypeName.toLowerCase(), relationshipTypeName, this.propertyText(relationshipTypeName.toLowerCase()), this.constraint.asPropertyTypeConstraint().propertyType().userDescription());
    }

    @Override
    public PropertyType[] getPropertyType() {
        this.assertInUnterminatedTransaction();
        PropertyTypeSet propertyTypeSet = this.constraint.asPropertyTypeConstraint().propertyType();
        return (PropertyType[])propertyTypeSet.stream().map(ConstrainableType::toPublicApi).toArray(PropertyType[]::new);
    }
}

