/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.reverse;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.kernel.impl.transaction.CommittedCommandBatchRepresentation;
import org.neo4j.kernel.impl.transaction.log.CommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.CommittedCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.ReadAheadLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.SketchingCommandBatchCursor;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.UnsupportedLogVersionException;
import org.neo4j.kernel.impl.transaction.log.reverse.ReservedBatch;
import org.neo4j.kernel.impl.transaction.log.reverse.ReversedTransactionCursorMonitor;

public class ReversedSingleFileCommandBatchCursor
implements CommandBatchCursor {
    private static final int CHUNK_SIZE = ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE;
    private final ReadAheadLogChannel channel;
    private final boolean failOnCorruptedLogFiles;
    private final ReversedTransactionCursorMonitor monitor;
    private final CommandBatchCursor commandBatchCursor;
    private final Deque<ReservedBatch> chunkBatches = new ArrayDeque<ReservedBatch>(20);
    private final SketchingCommandBatchCursor sketchingCursor;
    private CommittedCommandBatchRepresentation currentCommandBatch;
    private LogPosition currentBatchStartPosition;
    private final long[] offsets;
    private int offsetsLength;
    private int chunkStartOffsetIndex;
    private long totalSize;

    ReversedSingleFileCommandBatchCursor(ReadAheadLogChannel channel, LogEntryReader logEntryReader, boolean failOnCorruptedLogFiles, ReversedTransactionCursorMonitor monitor) throws IOException {
        this.channel = channel;
        this.failOnCorruptedLogFiles = failOnCorruptedLogFiles;
        this.monitor = monitor;
        this.commandBatchCursor = new CommittedCommandBatchCursor((ReadableLogPositionAwareChannel)channel, logEntryReader);
        this.sketchingCursor = new SketchingCommandBatchCursor((ReadableLogPositionAwareChannel)channel, logEntryReader);
        this.offsets = this.sketchOutTransactionStartOffsets();
    }

    private long[] sketchOutTransactionStartOffsets() throws IOException {
        long logVersion;
        int offsetCursor;
        long[] offsets;
        block5: {
            offsets = new long[10000];
            offsetCursor = 0;
            logVersion = this.channel.getLogVersion();
            long startOffset = this.channel.position();
            try {
                while (this.sketchingCursor.next()) {
                    if (offsetCursor == offsets.length) {
                        offsets = Arrays.copyOf(offsets, offsetCursor * 2);
                    }
                    offsets[offsetCursor++] = startOffset;
                    startOffset = this.channel.position();
                }
            }
            catch (IOException | IllegalStateException | UnsupportedLogVersionException e) {
                this.monitor.transactionalLogRecordReadFailure(offsets, offsetCursor, logVersion);
                if (!this.failOnCorruptedLogFiles) break block5;
                throw e;
            }
        }
        if (this.channel.getLogVersion() != logVersion) {
            throw new IllegalArgumentException("The channel which was passed in bridged multiple log versions, it started at version " + logVersion + ", but continued through to version " + this.channel.getLogVersion() + ". This isn't supported");
        }
        this.offsetsLength = offsetCursor;
        this.chunkStartOffsetIndex = offsetCursor;
        this.totalSize = this.channel.position();
        return offsets;
    }

    public boolean next() throws IOException {
        if (!this.exhausted()) {
            if (this.currentChunkExhausted()) {
                this.readNextChunk();
            }
            ReservedBatch reservedBatch = this.chunkBatches.pop();
            this.currentCommandBatch = reservedBatch.commitedBatch();
            this.currentBatchStartPosition = reservedBatch.batchStartPosition();
            return true;
        }
        return false;
    }

    private void readNextChunk() throws IOException {
        long deltaOffset;
        assert (this.chunkStartOffsetIndex > 0);
        long highOffset = this.chunkStartOffsetIndex == this.offsetsLength ? this.totalSize : this.offsets[this.chunkStartOffsetIndex];
        int newLowOffsetIndex = this.chunkStartOffsetIndex;
        while (newLowOffsetIndex > 0 && (deltaOffset = highOffset - this.offsets[--newLowOffsetIndex]) <= (long)CHUNK_SIZE) {
        }
        assert (this.chunkStartOffsetIndex - newLowOffsetIndex > 0);
        int chunkLength = this.chunkStartOffsetIndex - newLowOffsetIndex;
        this.chunkStartOffsetIndex = newLowOffsetIndex;
        this.channel.position(this.offsets[this.chunkStartOffsetIndex]);
        assert (this.chunkBatches.isEmpty());
        for (int i = 0; i < chunkLength; ++i) {
            boolean success = this.commandBatchCursor.next();
            assert (success);
            LogPosition batchStartPosition = new LogPosition(this.channel.getLogVersion(), this.offsets[this.chunkStartOffsetIndex + i]);
            this.chunkBatches.push(new ReservedBatch((CommittedCommandBatchRepresentation)this.commandBatchCursor.get(), batchStartPosition));
        }
    }

    private boolean currentChunkExhausted() {
        return this.chunkBatches.isEmpty();
    }

    private boolean exhausted() {
        return this.chunkStartOffsetIndex == 0 && this.currentChunkExhausted();
    }

    public void close() throws IOException {
        this.commandBatchCursor.close();
    }

    public CommittedCommandBatchRepresentation get() {
        return this.currentCommandBatch;
    }

    @Override
    public LogPosition position() {
        return this.currentBatchStartPosition;
    }
}

