/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.function.LongSupplier;
import org.eclipse.collections.api.map.primitive.LongObjectMap;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogForceEvents;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.PhysicalLogVersionedStoreChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogPositionAwareChannel;
import org.neo4j.kernel.impl.transaction.log.TransactionLogWriter;
import org.neo4j.kernel.impl.transaction.log.files.LogHeaderVisitor;
import org.neo4j.kernel.impl.transaction.log.files.LogVersionVisitor;
import org.neo4j.kernel.impl.transaction.log.files.RotatableFile;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFileInformation;
import org.neo4j.kernel.impl.transaction.log.files.VersionedFile;
import org.neo4j.kernel.impl.transaction.log.rotation.LogRotation;

public interface LogFile
extends VersionedFile,
RotatableFile {
    public TransactionLogWriter getTransactionLogWriter();

    public LogRotation getLogRotation();

    public ReadableLogChannel getReader(LogPosition var1) throws IOException;

    public ReadableLogChannel getRawReader(LogPosition var1) throws IOException;

    public void accept(LogFileVisitor var1, LogPosition var2) throws IOException;

    public TransactionLogFileInformation getLogFileInformation();

    public NativeScopedBuffer createScopedBuffer();

    public PhysicalLogVersionedStoreChannel openForVersion(long var1, boolean var3) throws IOException;

    public PhysicalLogVersionedStoreChannel createLogChannelForVersion(long var1, LongSupplier var3, KernelVersionProvider var4, int var5, LogFormatVersionProvider var6) throws IOException;

    public PhysicalLogVersionedStoreChannel createLogChannelForExistingVersion(long var1) throws IOException;

    public boolean versionExists(long var1);

    public boolean hasAnyEntries(long var1);

    public void accept(LogVersionVisitor var1);

    public void accept(LogHeaderVisitor var1) throws IOException;

    public void combine(Path var1) throws IOException;

    public boolean forceAfterAppend(LogForceEvents var1) throws IOException;

    public void locklessForce(LogForceEvents var1) throws IOException;

    public void flush() throws IOException;

    public void initializeMissingLogFile() throws IOException;

    public void truncate() throws IOException;

    public void truncate(LogPosition var1) throws IOException;

    public LogPosition append(ByteBuffer var1, OptionalLong var2, Optional<Byte> var3, int var4, long var5) throws IOException;

    public void registerExternalReaders(LongObjectMap<StoreChannel> var1);

    public void unregisterExternalReader(long var1, StoreChannel var3);

    public void terminateExternalReaders(long var1);

    public void delete(Long var1) throws IOException;

    public PositionWithPrevAppendIndex findSafeTruncationPointInPreviousFile(PositionWithPrevAppendIndex var1);

    public record PositionWithPrevAppendIndex(LogPosition position, long prevAppendIndexAtPosition) {
    }

    @FunctionalInterface
    public static interface LogFileVisitor {
        public boolean visit(ReadableLogPositionAwareChannel var1) throws IOException;
    }
}

