/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.checkpoint;

import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.helpers.Format;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.checkpoint.AbstractCheckPointThreshold;
import org.neo4j.time.Stopwatch;
import org.neo4j.time.SystemNanoClock;

class TimeCheckPointThreshold
extends AbstractCheckPointThreshold {
    private static final long NANOS_PER_MILLI = 1000000L;
    private static final long MAX_MILLIS = 9223372036854L;
    private volatile long lastCheckPointedAppendIndex;
    private volatile Duration timeout;
    private volatile Stopwatch stopWatch;
    private final long timeMillisThreshold;
    private final SystemNanoClock clock;

    TimeCheckPointThreshold(long thresholdMillis, SystemNanoClock clock) {
        super("every " + TimeCheckPointThreshold.formatDuration(thresholdMillis) + " threshold");
        this.timeMillisThreshold = thresholdMillis;
        this.clock = clock;
        this.timeout = TimeCheckPointThreshold.randomOffset(thresholdMillis);
        this.stopWatch = clock.startStopWatch();
    }

    @Override
    public void initialize(long appendIndex, LogPosition logPosition) {
        this.lastCheckPointedAppendIndex = appendIndex;
    }

    @Override
    protected boolean thresholdReached(long lastAppendIndex, LogPosition logPosition) {
        return lastAppendIndex > this.lastCheckPointedAppendIndex && this.stopWatch.hasTimedOut(this.timeout);
    }

    @Override
    public void checkPointHappened(long appendIndex, LogPosition logPosition) {
        this.lastCheckPointedAppendIndex = appendIndex;
        this.stopWatch = this.clock.startStopWatch();
        this.timeout = Duration.ofMillis(this.timeMillisThreshold);
    }

    @Override
    public long checkFrequencyMillis() {
        return this.timeMillisThreshold;
    }

    private static Duration randomOffset(long millis) {
        if ((millis += millis > 0L ? ThreadLocalRandom.current().nextLong(millis) : 0L) < 0L || millis > 9223372036854L) {
            return Duration.ofMillis(9223372036854L);
        }
        return Duration.ofMillis(millis);
    }

    private static String formatDuration(long thresholdMillis) {
        return Format.duration((long)thresholdMillis, (TimeUnit)TimeUnit.DAYS, (TimeUnit)TimeUnit.MILLISECONDS, unit -> " " + unit.name().toLowerCase());
    }
}

