/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.neo4j.common.EntityType;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.exceptions.KernelException;
import org.neo4j.function.Predicates;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.InternalIndexState;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipCursor;
import org.neo4j.internal.kernel.api.RelationshipIndexCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.RelationshipTypeIndexCursor;
import org.neo4j.internal.kernel.api.SchemaRead;
import org.neo4j.internal.kernel.api.TokenPredicate;
import org.neo4j.internal.kernel.api.TokenReadSession;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotFoundKernelException;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.AnyTokenSchemaDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.CursorPredicates;
import org.neo4j.kernel.impl.newapi.FilteringRelationshipScanCursorWrapper;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CountsDelta;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TransactionCountingStateVisitor;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;

final class EntityCounter {
    private final boolean multiVersioned;

    public EntityCounter(boolean multiVersioned) {
        this.multiVersioned = multiVersioned;
    }

    long countsForNode(int labelId, AccessMode accessMode, StorageReader storageReader, CursorFactory cursors, CursorContext cursorContext, MemoryTracker memoryTracker, Read read, StoreCursors storageCursors, TxStateHolder txStateHolder) {
        if (!this.multiVersioned && accessMode.allowsTraverseAllNodesWithLabel(labelId)) {
            return storageReader.countsForNode(labelId, cursorContext) + EntityCounter.countsForNodeInTxState(labelId, storageReader, cursorContext, storageCursors, txStateHolder, memoryTracker);
        }
        if (accessMode.disallowsTraverseLabel(labelId)) {
            return EntityCounter.countsForNodeInTxState(labelId, storageReader, cursorContext, storageCursors, txStateHolder, memoryTracker);
        }
        return EntityCounter.countNodesByScan(labelId, cursors, cursorContext, memoryTracker, read);
    }

    private static long countsForNodeInTxState(int labelId, StorageReader storageReader, CursorContext cursorContext, StoreCursors storageCursors, TxStateHolder txStateHolder, MemoryTracker memoryTracker) {
        long count = 0L;
        if (txStateHolder.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = txStateHolder.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, storageReader, (ReadableTransactionState)txState, counts, cursorContext, storageCursors, memoryTracker);){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.nodeCount(labelId);
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    private static long countNodesByScan(int labelId, CursorFactory cursors, CursorContext cursorContext, MemoryTracker memoryTracker, Read read) {
        long count = 0L;
        try (NodeCursor nodes = cursors.allocateNodeCursor(cursorContext, memoryTracker);){
            read.allNodesScan(nodes);
            while (nodes.next()) {
                if (labelId != -1 && !nodes.hasLabel(labelId)) continue;
                ++count;
            }
        }
        return count;
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId, AccessMode accessMode, StorageReader storageReader, CursorFactory cursors, Read read, CursorContext cursorContext, MemoryTracker memoryTracker, StoreCursors storageCursors, SchemaRead schemaRead, TxStateHolder txStateHolder) {
        if (!this.multiVersioned && accessMode.allowsTraverseRelType(typeId) && accessMode.allowsTraverseNode(new int[]{startLabelId}) && accessMode.allowsTraverseNode(new int[]{endLabelId})) {
            return storageReader.countsForRelationship(startLabelId, typeId, endLabelId, cursorContext) + this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId, txStateHolder, storageReader, storageCursors, cursorContext, memoryTracker);
        }
        if (accessMode.disallowsTraverseRelType(typeId) || accessMode.disallowsTraverseLabel(startLabelId) || accessMode.disallowsTraverseLabel(endLabelId)) {
            return this.countsForRelationshipInTxState(startLabelId, typeId, endLabelId, txStateHolder, storageReader, storageCursors, cursorContext, memoryTracker);
        }
        return this.countRelationshipByScan(startLabelId, typeId, endLabelId, cursors, read, schemaRead, cursorContext, memoryTracker);
    }

    private long countRelationshipByScan(int startLabelId, int typeId, int endLabelId, CursorFactory cursors, Read read, SchemaRead schemaRead, CursorContext cursorContext, MemoryTracker memoryTracker) {
        long count;
        block39: {
            if (typeId != -1) {
                try {
                    NodeCursor targetNode;
                    NodeCursor sourceNode;
                    IndexDescriptor index = this.findUsableRelationshipTypeTokenIndex(schemaRead);
                    if (index == IndexDescriptor.NO_INDEX) break block39;
                    long count2 = 0L;
                    try (RelationshipTypeIndexCursor relationshipsWithType = cursors.allocateRelationshipTypeIndexCursor(cursorContext, memoryTracker);){
                        sourceNode = cursors.allocateNodeCursor(cursorContext, memoryTracker);
                        try {
                            targetNode = cursors.allocateNodeCursor(cursorContext, memoryTracker);
                            try {
                                TokenReadSession session = read.tokenReadSession(index);
                                read.relationshipTypeScan(session, relationshipsWithType, IndexQueryConstraints.unconstrained(), new TokenPredicate(typeId), cursorContext);
                            }
                            finally {
                                if (targetNode != null) {
                                    targetNode.close();
                                }
                            }
                        }
                        finally {
                            if (sourceNode != null) {
                                sourceNode.close();
                            }
                        }
                    }
                    return count2 += EntityCounter.countRelationshipsWithEndLabels((RelationshipIndexCursor)relationshipsWithType, sourceNode, targetNode, startLabelId, endLabelId);
                }
                catch (KernelException index) {
                    // empty catch block
                }
            }
        }
        try (RelationshipScanCursor rels = cursors.allocateRelationshipScanCursor(cursorContext, memoryTracker);
             NodeCursor sourceNode = cursors.allocateFullAccessNodeCursor(cursorContext, memoryTracker);
             NodeCursor targetNode = cursors.allocateFullAccessNodeCursor(cursorContext, memoryTracker);){
            read.allRelationshipsScan(rels);
            Predicate<RelationshipScanCursor> predicate = typeId == -1 ? Predicates.alwaysTrue() : CursorPredicates.hasType(typeId);
            FilteringRelationshipScanCursorWrapper filteredCursor = new FilteringRelationshipScanCursorWrapper(rels, predicate);
            count = EntityCounter.countRelationshipsWithEndLabels(filteredCursor, sourceNode, targetNode, startLabelId, endLabelId);
        }
        return count;
    }

    private IndexDescriptor findUsableRelationshipTypeTokenIndex(SchemaRead schemaRead) throws IndexNotFoundKernelException {
        AnyTokenSchemaDescriptor descriptor = SchemaDescriptors.forAnyEntityTokens((EntityType)EntityType.RELATIONSHIP);
        IndexDescriptor index = schemaRead.index((SchemaDescriptor)descriptor, IndexType.LOOKUP);
        if (index != IndexDescriptor.NO_INDEX && schemaRead.indexGetState(index) == InternalIndexState.ONLINE) {
            return index;
        }
        return IndexDescriptor.NO_INDEX;
    }

    private static long countRelationshipsWithEndLabels(RelationshipIndexCursor relationship, NodeCursor sourceNode, NodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            if (!relationship.readFromStore() || !EntityCounter.matchesLabels((RelationshipCursor)relationship, sourceNode, targetNode, startLabelId, endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private static long countRelationshipsWithEndLabels(RelationshipScanCursor relationship, NodeCursor sourceNode, NodeCursor targetNode, int startLabelId, int endLabelId) {
        long internalCount = 0L;
        while (relationship.next()) {
            if (!EntityCounter.matchesLabels((RelationshipCursor)relationship, sourceNode, targetNode, startLabelId, endLabelId)) continue;
            ++internalCount;
        }
        return internalCount;
    }

    private static boolean matchesLabels(RelationshipCursor relationship, NodeCursor sourceNode, NodeCursor targetNode, int startLabelId, int endLabelId) {
        relationship.source(sourceNode);
        relationship.target(targetNode);
        return !(!sourceNode.next() || startLabelId != -1 && !sourceNode.hasLabel(startLabelId) || !targetNode.next() || endLabelId != -1 && !targetNode.hasLabel(endLabelId));
    }

    private long countsForRelationshipInTxState(int startLabelId, int typeId, int endLabelId, TxStateHolder txStateHolder, StorageReader storageReader, StoreCursors storageCursors, CursorContext cursorContext, MemoryTracker memoryTracker) {
        long count = 0L;
        if (txStateHolder.hasTxStateWithChanges()) {
            CountsDelta counts = new CountsDelta();
            try {
                TransactionState txState = txStateHolder.txState();
                try (TransactionCountingStateVisitor countingVisitor = new TransactionCountingStateVisitor(TxStateVisitor.EMPTY, storageReader, (ReadableTransactionState)txState, counts, cursorContext, storageCursors, memoryTracker);){
                    txState.accept((TxStateVisitor)countingVisitor);
                }
                if (counts.hasChanges()) {
                    count += counts.relationshipCount(startLabelId, typeId, endLabelId);
                }
            }
            catch (KernelException e) {
                throw new IllegalArgumentException("Unexpected error: " + e.getMessage());
            }
        }
        return count;
    }

    public List<Integer> mostCommonLabelGivenRelationshipType(int type, StorageReader storageReader, CursorContext cursorContext) {
        MostCommonLabelGivenRelTypeVisitor visitor = new MostCommonLabelGivenRelTypeVisitor(type);
        storageReader.visitAllCounts((CountsVisitor)visitor, cursorContext);
        return visitor.highest;
    }

    private static class MostCommonLabelGivenRelTypeVisitor
    implements CountsVisitor {
        private final int relationshipType;
        private long labelCount = -1L;
        public ArrayList<Integer> highest = new ArrayList();

        public MostCommonLabelGivenRelTypeVisitor(int relationshipType) {
            this.relationshipType = relationshipType;
        }

        public void visitNodeCount(int labelId, long count) {
        }

        public void visitRelationshipCount(int startLabelId, int typeId, int endLabelId, long count) {
            if (typeId == this.relationshipType && startLabelId > -1 ^ endLabelId > -1) {
                int labelId;
                int n = labelId = startLabelId > -1 ? startLabelId : endLabelId;
                if (count > this.labelCount) {
                    this.labelCount = count;
                    this.highest = new ArrayList<Integer>(List.of(Integer.valueOf(labelId)));
                } else if (count == this.labelCount) {
                    this.highest.add(labelId);
                }
            }
        }
    }
}

