/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.DbmsRuntimeVersionProvider;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.UpgradeLocker;
import org.neo4j.kernel.impl.api.KernelImpl;
import org.neo4j.kernel.impl.api.MaximumTransactionLimitExceededException;
import org.neo4j.kernel.impl.locking.LockAcquisitionTimeoutException;
import org.neo4j.kernel.internal.event.DatabaseTransactionEventListeners;
import org.neo4j.kernel.internal.event.InternalTransactionEventListener;
import org.neo4j.lock.Lock;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

class DatabaseUpgradeTransactionHandler {
    private final DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider;
    private final KernelVersionProvider kernelVersionProvider;
    private final DatabaseTransactionEventListeners transactionEventListeners;
    private final AtomicBoolean unregistered = new AtomicBoolean();
    private final UpgradeLocker locker;
    private final InternalLog log;
    private final Config config;
    private final KernelImpl kernelApi;

    DatabaseUpgradeTransactionHandler(DbmsRuntimeVersionProvider dbmsRuntimeVersionProvider, KernelVersionProvider kernelVersionProvider, DatabaseTransactionEventListeners transactionEventListeners, UpgradeLocker locker, InternalLogProvider logProvider, Config config, KernelImpl kernelApi) {
        this.dbmsRuntimeVersionProvider = dbmsRuntimeVersionProvider;
        this.kernelVersionProvider = kernelVersionProvider;
        this.transactionEventListeners = transactionEventListeners;
        this.locker = locker;
        this.log = logProvider.getLog(this.getClass());
        this.config = config;
        this.kernelApi = kernelApi;
    }

    void registerUpgradeListener(InternalUpgradeTransactionHandler internalUpgradeTransactionHandler) {
        if (!this.kernelVersionProvider.kernelVersion().isLatest(this.config)) {
            this.transactionEventListeners.registerTransactionEventListener(new DatabaseUpgradeListener(internalUpgradeTransactionHandler));
        }
    }

    private class DatabaseUpgradeListener
    extends InternalTransactionEventListener.Adapter<Lock> {
        private final InternalUpgradeTransactionHandler internalUpgradeTransactionHandler;
        private volatile long upgradeTxSeqNbr = -1L;

        DatabaseUpgradeListener(InternalUpgradeTransactionHandler internalUpgradeTransactionHandler) {
            this.internalUpgradeTransactionHandler = internalUpgradeTransactionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Lock beforeCommit(TransactionData data, KernelTransaction tx, GraphDatabaseService databaseService) throws Exception {
            block21: {
                KernelVersion checkKernelVersion = DatabaseUpgradeTransactionHandler.this.kernelVersionProvider.kernelVersion();
                if (DatabaseUpgradeTransactionHandler.this.dbmsRuntimeVersionProvider.getVersion().kernelVersion().isGreaterThan(checkKernelVersion)) {
                    try {
                        if (tx.getTransactionSequenceNumber() == this.upgradeTxSeqNbr) {
                            return null;
                        }
                        try (Lock lock = DatabaseUpgradeTransactionHandler.this.locker.acquireWriteLock(tx);){
                            KernelVersion kernelVersionToUpgradeTo = DatabaseUpgradeTransactionHandler.this.dbmsRuntimeVersionProvider.getVersion().kernelVersion();
                            KernelVersion currentKernelVersion = DatabaseUpgradeTransactionHandler.this.kernelVersionProvider.kernelVersion();
                            if (!kernelVersionToUpgradeTo.isGreaterThan(currentKernelVersion)) break block21;
                            DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s started", new Object[]{currentKernelVersion, kernelVersionToUpgradeTo});
                            try (KernelTransaction upgradeTx = DatabaseUpgradeTransactionHandler.this.kernelApi.beginTransaction(KernelTransaction.Type.IMPLICIT, LoginContext.AUTH_DISABLED);){
                                this.upgradeTxSeqNbr = upgradeTx.getTransactionSequenceNumber();
                                this.internalUpgradeTransactionHandler.upgrade(currentKernelVersion, kernelVersionToUpgradeTo, upgradeTx);
                                upgradeTx.commit();
                            }
                            finally {
                                this.upgradeTxSeqNbr = -1L;
                            }
                            DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s completed", new Object[]{currentKernelVersion, kernelVersionToUpgradeTo});
                        }
                    }
                    catch (DeadlockDetectedException | LockAcquisitionTimeoutException ignore) {
                        DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s not possible right now due to conflicting transaction, will retry on next write", new Object[]{checkKernelVersion, DatabaseUpgradeTransactionHandler.this.dbmsRuntimeVersionProvider.getVersion().kernelVersion()});
                    }
                    catch (MaximumTransactionLimitExceededException e) {
                        DatabaseUpgradeTransactionHandler.this.log.error("Upgrade transaction from %s to %s not possible right now because maximum concurrently executed transactions was reached, will retry on next write. If this persists see setting %s.", new Object[]{checkKernelVersion, DatabaseUpgradeTransactionHandler.this.dbmsRuntimeVersionProvider.getVersion().kernelVersion(), GraphDatabaseSettings.max_concurrent_transactions.name()});
                    }
                    catch (Exception e) {
                        DatabaseUpgradeTransactionHandler.this.log.info("Upgrade transaction from %s to %s not possible right now due exception with message: '%s', will retry on next write", new Object[]{checkKernelVersion, DatabaseUpgradeTransactionHandler.this.dbmsRuntimeVersionProvider.getVersion().kernelVersion(), e});
                        throw e;
                    }
                }
            }
            return DatabaseUpgradeTransactionHandler.this.locker.acquireReadLock(tx);
        }

        public void afterCommit(TransactionData data, Lock readLock, GraphDatabaseService databaseService) {
            this.checkUnlockAndUnregister(readLock);
        }

        public void afterRollback(TransactionData data, Lock readLock, GraphDatabaseService databaseService) {
            this.checkUnlockAndUnregister(readLock);
        }

        private void checkUnlockAndUnregister(Lock readLock) {
            if (readLock == null) {
                return;
            }
            readLock.close();
            if (DatabaseUpgradeTransactionHandler.this.kernelVersionProvider.kernelVersion().isLatest(DatabaseUpgradeTransactionHandler.this.config) && DatabaseUpgradeTransactionHandler.this.unregistered.compareAndSet(false, true)) {
                try {
                    DatabaseUpgradeTransactionHandler.this.transactionEventListeners.unregisterTransactionEventListener(this);
                }
                catch (Throwable e) {
                    DatabaseUpgradeTransactionHandler.this.unregistered.set(false);
                    throw e;
                }
            }
        }
    }

    static interface InternalUpgradeTransactionHandler {
        public void upgrade(KernelVersion var1, KernelVersion var2, KernelTransaction var3) throws TransactionFailureException;
    }
}

