/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import org.neo4j.internal.helpers.collection.NumberAwareStringComparator;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.Validators;
import org.neo4j.util.Preconditions;

public class Converters {
    private static final Comparator<Path> BY_FILE_NAME = Comparator.comparing(Path::getFileName);
    private static final Comparator<Path> BY_FILE_NAME_WITH_CLEVER_NUMBERS = (o1, o2) -> NumberAwareStringComparator.INSTANCE.compare(o1.toAbsolutePath().toString(), o2.toAbsolutePath().toString());

    private Converters() {
    }

    public static <T> Function<String, T> optional() {
        return from -> null;
    }

    public static Function<String, Path[]> regexFiles(FileSystemAbstraction fs, boolean cleverNumberRegexSort) {
        return name -> {
            Comparator<Path> sorting = cleverNumberRegexSort ? BY_FILE_NAME_WITH_CLEVER_NUMBERS : BY_FILE_NAME;
            List<Path> files = Validators.matchingFiles(fs, name.trim());
            files.sort(sorting);
            return files.toArray(new Path[0]);
        };
    }

    public static Function<String, Path[]> toFiles(String delimiter, Function<String, Path[]> eachFileConverter) {
        return from -> {
            if (from == null) {
                return new Path[0];
            }
            String[] names = Converters.quotationAwareSplit(from, delimiter);
            ArrayList<Path> files = new ArrayList<Path>();
            for (String name : names) {
                files.addAll(Arrays.asList((Path[])eachFileConverter.apply(name)));
            }
            return files.toArray(new Path[0]);
        };
    }

    private static String[] quotationAwareSplit(String from, String delimiter) {
        String[] parts = from.split(delimiter);
        ArrayList<String> mendedParts = new ArrayList<String>();
        for (int i = 0; i < parts.length; ++i) {
            Object part = parts[i];
            if (((String)part).startsWith("'")) {
                while (!((String)part).endsWith("'")) {
                    Preconditions.checkState((i + 1 < parts.length ? 1 : 0) != 0, (String)"When splitting \"%s\" the inner start quote in part \"%s\" had no matching end quote", (Object[])new Object[]{from, part});
                    part = (String)part + delimiter + parts[++i];
                }
                part = ((String)part).substring(1, ((String)part).length() - 1);
            }
            mendedParts.add((String)part);
        }
        return mendedParts.toArray(new String[0]);
    }
}

