/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.IndexMonitor;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;

public final class TransactionQueryContext
implements QueryContext {
    private final Supplier<Read> read;
    private final CursorFactory cursorFactory;
    private final TxStateHolder txStateHolder;
    private final Supplier<CursorContext> cursorContext;
    private final MemoryTracker memoryTracker;
    private final IndexMonitor indexMonitor;

    public TransactionQueryContext(Supplier<Read> read, CursorFactory cursorFactory, TxStateHolder txStateHolder, Supplier<CursorContext> cursorContext, MemoryTracker memoryTracker, IndexMonitor indexMonitor) {
        this.read = read;
        this.cursorFactory = cursorFactory;
        this.txStateHolder = txStateHolder;
        this.cursorContext = cursorContext;
        this.memoryTracker = memoryTracker;
        this.indexMonitor = indexMonitor;
    }

    public Read getRead() {
        return this.read.get();
    }

    public CursorFactory cursors() {
        return this.cursorFactory;
    }

    public ReadableTransactionState getTransactionStateOrNull() {
        return this.txStateHolder.hasTxStateWithChanges() ? this.txStateHolder.txState() : null;
    }

    public CursorContext cursorContext() {
        return this.cursorContext.get();
    }

    public MemoryTracker memoryTracker() {
        return this.memoryTracker;
    }

    public IndexMonitor monitor() {
        return this.indexMonitor;
    }
}

