/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.Read;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.kernel.api.AccessModeProvider;
import org.neo4j.kernel.api.txstate.TxStateHolder;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.InternalCursorFactory;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageRelationshipCursor;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

public class DefaultRelationshipScanCursor
extends DefaultRelationshipCursor<DefaultRelationshipScanCursor>
implements RelationshipScanCursor {
    private final StorageRelationshipScanCursor storeCursor;
    private long single;
    private boolean isSingle;

    protected DefaultRelationshipScanCursor(CursorPool<DefaultRelationshipScanCursor> pool, StorageRelationshipScanCursor storeCursor, InternalCursorFactory internalCursors, boolean applyAccessModeToTxState) {
        super((StorageRelationshipCursor)storeCursor, pool, applyAccessModeToTxState, internalCursors);
        this.storeCursor = storeCursor;
    }

    void scan(Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.storeCursor.scan();
        this.single = -1L;
        this.isSingle = false;
    }

    boolean scanBatch(Read read, AllRelationshipsScan scan, long sizeHint, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.single = -1L;
        this.isSingle = false;
        this.prepareChanges((LongIterator)ImmutableEmptyLongIterator.INSTANCE, false);
        return this.storeCursor.scanBatch((Scan)scan, sizeHint);
    }

    void single(long reference, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.storeCursor.single(reference);
        this.single = reference;
        this.isSingle = true;
    }

    void single(long reference, long sourceNodeReference, int type, long targetNodeReference, Read read, TxStateHolder txStateHolder, AccessModeProvider accessModeProvider) {
        this.init(read, txStateHolder, accessModeProvider);
        this.storeCursor.single(reference, sourceNodeReference, type, targetNodeReference);
        this.single = reference;
        this.isSingle = true;
    }

    @Override
    protected boolean filterOutTxStateRelationship() {
        return false;
    }

    @Override
    protected boolean allowedToTraverseEndNodes() {
        if (this.allowAllNodes) {
            return true;
        }
        DefaultNodeCursor nodeCursor = this.getSecurityNodeCursor();
        boolean useTxStateRef = this.applyAccessModeToTxState && this.currentAddedInTx != -1L;
        long sourceNode = useTxStateRef ? this.txStateSourceNodeReference : this.storeCursor.sourceNodeReference();
        this.read.singleNode(sourceNode, (NodeCursor)nodeCursor);
        if (nodeCursor.next()) {
            long targetNode = useTxStateRef ? this.txStateTargetNodeReference : this.storeCursor.targetNodeReference();
            this.read.singleNode(targetNode, (NodeCursor)nodeCursor);
            return nodeCursor.next();
        }
        return false;
    }

    @Override
    protected LongIterator collectAddedTxStateSnapshot(TxStateHolder stateHolder) {
        if (this.isSingle) {
            return stateHolder.txState().relationshipIsAddedInThisBatch(this.single) ? LongHashSet.newSetWith((long[])new long[]{this.single}).longIterator() : ImmutableEmptyLongIterator.INSTANCE;
        }
        return stateHolder.txState().addedAndRemovedRelationships().getAdded().freeze().longIterator();
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + this.storeCursor.entityReference() + ", open state with: single=" + this.single + ", " + String.valueOf(this.storeCursor) + "]";
    }
}

