/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api;

import java.time.Duration;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.kernel.api.CursorFactory;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.kernel.api.Kernel;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.api.TransactionTimeout;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.api.procedure.CallableProcedure;
import org.neo4j.kernel.api.procedure.CallableUserAggregationFunction;
import org.neo4j.kernel.api.procedure.CallableUserFunction;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.impl.api.KernelTransactions;
import org.neo4j.kernel.impl.monitoring.TransactionMonitor;
import org.neo4j.kernel.impl.newapi.DefaultThreadSafeCursors;
import org.neo4j.kernel.impl.query.TransactionExecutionMonitor;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.monitoring.Panic;
import org.neo4j.storageengine.api.StorageEngine;

public class KernelImpl
extends LifecycleAdapter
implements Kernel {
    private final KernelTransactions transactions;
    private final Panic panic;
    private final TransactionMonitor transactionMonitor;
    private final TransactionExecutionMonitor transactionExecutionMonitor;
    private final GlobalProcedures globalProcedures;
    private final Config config;
    private final DefaultThreadSafeCursors cursors;

    public KernelImpl(KernelTransactions transactions, Panic panic, TransactionMonitor transactionMonitor, GlobalProcedures globalProcedures, Config config, StorageEngine storageEngine, TransactionExecutionMonitor transactionExecutionMonitor) {
        this.transactions = transactions;
        this.panic = panic;
        this.transactionMonitor = transactionMonitor;
        this.globalProcedures = globalProcedures;
        this.config = config;
        this.cursors = new DefaultThreadSafeCursors(storageEngine.newReader(), config, arg_0 -> ((StorageEngine)storageEngine).createStorageCursors(arg_0), storageEngine.indexingBehaviour(), storageEngine.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED));
        this.transactionExecutionMonitor = transactionExecutionMonitor;
    }

    @Override
    public KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext) throws TransactionFailureException {
        return this.beginTransaction(type, loginContext, ClientConnectionInfo.EMBEDDED_CONNECTION);
    }

    @Override
    public KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo) throws TransactionFailureException {
        return this.beginTransaction(type, loginContext, connectionInfo, new TransactionTimeout((Duration)this.config.get(GraphDatabaseSettings.transaction_timeout), (Status)Status.Transaction.TransactionTimedOut));
    }

    @Override
    public KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, long timeout) throws TransactionFailureException {
        return this.beginTransaction(type, loginContext, connectionInfo, new TransactionTimeout(Duration.ofMillis(timeout), (Status)Status.Transaction.TransactionTimedOutClientConfiguration));
    }

    private KernelTransaction beginTransaction(KernelTransaction.Type type, LoginContext loginContext, ClientConnectionInfo connectionInfo, TransactionTimeout timeout) throws TransactionFailureException {
        this.panic.assertNoPanic((msg, cause) -> TransactionFailureException.internalError((String)this.getClass().getSimpleName(), (String)msg, (Throwable)cause));
        KernelTransaction transaction = this.transactions.newInstance(type, loginContext, connectionInfo, timeout);
        this.transactionMonitor.transactionStarted();
        this.transactionExecutionMonitor.start(transaction);
        return transaction;
    }

    @Override
    public void registerProcedure(CallableProcedure procedure) throws ProcedureException {
        this.globalProcedures.register(procedure);
    }

    @Override
    public void registerUserFunction(CallableUserFunction function) throws ProcedureException {
        this.globalProcedures.register(function);
    }

    @Override
    public void registerUserAggregationFunction(CallableUserAggregationFunction function) throws ProcedureException {
        this.globalProcedures.register(function);
    }

    @Override
    public CursorFactory cursors() {
        return this.cursors;
    }

    public void shutdown() {
        this.cursors.close();
    }
}

